% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCohortAttrition.R
\name{plotCohortAttrition}
\alias{plotCohortAttrition}
\title{create a ggplot from the output of summariseLargeScaleCharacteristics.}
\usage{
plotCohortAttrition(x, cohortId = NULL)
}
\arguments{
\item{x}{attrition table}

\item{cohortId}{target cohort_definition_id}
}
\value{
A dgr_graph
}
\description{
`r lifecycle::badge("experimental")`
}
\examples{
\donttest{
library(omopgenerics)
library(dplyr)
library(DiagrammeR)

cdm <- mockCohortCharacteristics(numberIndividuals = 1000)

cdm[["cohort1"]] <- cdm[["cohort1"]] |>
  filter(year(cohort_start_date) >= 2000) |>
  recordCohortAttrition("Restrict to cohort_start_date >= 2000") |>
  filter(year(cohort_end_date) < 2020) |>
  recordCohortAttrition("Restrict to cohort_end_date < 2020") |>
  compute(temporary = FALSE, name = "cohort1")

cdm$cohort1 |>
  summariseCohortAttrition() |>
  plotCohortAttrition(cohortId = 2)
}

}
