% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/requireDemographics.R
\name{requirePriorObservation}
\alias{requirePriorObservation}
\title{Restrict cohort on prior observation}
\usage{
requirePriorObservation(
  cohort,
  minPriorObservation,
  cohortId = NULL,
  indexDate = "cohort_start_date",
  name = tableName(cohort)
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{minPriorObservation}{A minimum number of prior observation days in
the database.}

\item{cohortId}{IDs of the cohorts to modify. If NULL, all cohorts will be
used; otherwise, only the specified cohorts will be modified, and the
rest will remain unchanged.}

\item{indexDate}{Variable in cohort that contains the date to compute the
demographics characteristics on which to restrict on.}

\item{name}{Name of the new cohort with the prior observation restriction.}
}
\value{
The cohort table with only records for individuals satisfying the
prior observation requirement
}
\description{
Restrict cohort on prior observation
}
\examples{
\donttest{
library(CohortConstructor)
cdm <- mockCohortConstructor()
cdm$cohort1 |>
  requirePriorObservation(indexDate = "cohort_start_date",
                          minPriorObservation = 365)
}
}
