% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchCohorts.R
\name{matchCohorts}
\alias{matchCohorts}
\title{Generate a new cohort matched cohort}
\usage{
matchCohorts(
  cohort,
  cohortId = NULL,
  matchSex = TRUE,
  matchYearOfBirth = TRUE,
  ratio = 1,
  name = tableName(cohort)
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{cohortId}{IDs of the cohorts to include. If NULL all cohorts will be
considered. Cohorts not included will be removed from the cohort set.}

\item{matchSex}{Whether to match in sex.}

\item{matchYearOfBirth}{Whether to match in year of birth.}

\item{ratio}{Number of allowed matches per individual in the target cohort.}

\item{name}{Name of the new generated cohort set.}
}
\value{
A cohort table.
}
\description{
\code{matchCohorts()} generate a new cohort matched to individuals in an
existing cohort. Individuals can be matched based on year of birth and sex.
}
\examples{
\donttest{
library(CohortConstructor)
library(dplyr)
cdm <- mockCohortConstructor(nPerson = 200)
cdm$new_matched_cohort <- cdm$cohort2 |>
  matchCohorts(
    name = "new_matched_cohort",
    cohortId = 2,
    matchSex = TRUE,
    matchYearOfBirth = TRUE,
    ratio = 1)
cdm$new_matched_cohort
}
}
