% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableSurvival.R
\name{tableSurvival}
\alias{tableSurvival}
\title{Table with survival summary}
\usage{
tableSurvival(x, times = NULL)
}
\arguments{
\item{x}{Result from estimateSingleEventSurvival or estimateCompetingRiskSurvival}

\item{times}{Times at which to report survival in the summary table}
}
\value{
A tibble containing a summary of observed survival in days
}
\description{
Table with survival summary
}
\examples{
\donttest{
cdm <- mockMGUS2cdm()
surv <- estimateSingleEventSurvival(cdm,
                                    targetCohortTable = "mgus_diagnosis",
                                    outcomeCohortTable = "death_cohort")
tableSurvival(surv, times = c(50,100,365))
}
}
