% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/displayTables.R
\name{tableSequenceRatios}
\alias{tableSequenceRatios}
\title{A formatted visualization of sequence_symmetry objects.}
\usage{
tableSequenceRatios(
  result,
  type = "gt",
  estimateNameFormat = c(`N (\%)` = "<count> (<percentage> \%)", `SR (CI)` =
    "<point_estimate> (<lower_CI> - <upper_CI>)"),
  style = "default",
  studyPopulation = TRUE,
  cdmName = TRUE,
  .options = NULL
)
}
\arguments{
\item{result}{A sequence_symmetry object.}

\item{type}{Type of desired formatted table, possibilities: "gt",
"flextable", "tibble".}

\item{estimateNameFormat}{The columns that the user wishes to see for the
formatted table, by default it would display both the counts and sequence ratios.}

\item{style}{Named list that specifies how to style the different parts of a
gt table or flextable. See visOmopResults package for more information on
how to define a style. Alternatively, use "default" to get visOmopResults
style, or NULL for gt/flextable default styling.}

\item{studyPopulation}{whether to report the study population.}

\item{cdmName}{whether to report database names.}

\item{.options}{named list with additional formatting options.
tableSequenceRatiosOptions() shows allowed arguments and
their default values.}
}
\value{
A formatted version of the sequence_symmetry object.
}
\description{
It provides a formatted table with the contents of the summariseSequenceRatios
output.
}
\examples{
\donttest{
library(CohortSymmetry)
cdm <- mockCohortSymmetry()
cdm <- generateSequenceCohortSet(cdm = cdm,
                                 indexTable = "cohort_1",
                                 markerTable = "cohort_2",
                                 name = "joined_cohort")
res <- summariseSequenceRatios(cohort = cdm$joined_cohort)
gtResult <- tableSequenceRatios(res)
CDMConnector::cdmDisconnect(cdm = cdm)
}


}
