% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_permute.R
\name{gcdhPower}
\alias{gcdhPower}
\title{GCDH power analysis}
\usage{
gcdhPower(rbed_info, n_shift, n_simu, maf_min, maf_max, r_limit, beta,
  collapse_matrix = NULL, dist_threshold = 5e+05, alpha_level = 0.05)
}
\arguments{
\item{rbed_info}{RbedInfoC object}

\item{n_shift}{integer. \code{n_shift} for each GCDH run.}

\item{n_simu}{integer. Number of simulations to run.}

\item{maf_min}{numeric. Lower limit of MAF interval.}

\item{maf_max}{numeric. Upper limit of MAF interval.}

\item{r_limit}{numeric. Upper limit of correlation coefficient between the two causal SNPs.}

\item{beta}{numeric. Effect size of the simulated phenotype.}

\item{collapse_matrix}{See runGcdh.}

\item{dist_threshold}{See runGcdh.}

\item{alpha_level}{numeric. Control type-I error rate at this level.}
}
\description{
This function makes use of \code{runTypeI}. 
Random phenotypes are used to survey p-values under the null hypothesis (SNPs are not associated phenotype), 
and genome-wide significance thresholds for single-SNP approach and GCDH are calculated by a user given 
alpha-level.
A custom \code{phe_fun} is supplied 
for simulating a phenotype associated with a certain pair of SNPs. 
Total number of such simulations is set by the n_simu parameter. In each simulation 4 p-values are generated:
}
\details{
P_single: p-values from single-SNP approach.

P_GCDH:  p-values from GCDH.

P_(single,no causal): p-values from single-SNP approach when causal SNPs are untyped.

P_(GCDH,no causal): p-values from GCDH when causal SNPs are untyped.

When all simulations are finished, 
4 vectors of p-values are obtained: P_single_vec, P_GCDH_vec, P_(single,no causal)_vec, P_(GCDH,no causal)_vec.
The power for each of the category (single-SNP, single-SNP without causal genotypes, GCDH, GCDH without causal genotypes)
are proportions of these vectors that are more significant than the genome-wide significance thresholds 
we have obtained.
}
\author{
Kaiyin Zhong
}

