% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{digital_centers_tbl_df}
\alias{digital_centers_tbl_df}
\title{Digital Centers in Sucre (Spanish speaking)}
\format{
A tibble with 475 observations and 8 variables:
\describe{
  \item{NOMBRE DEPARTAMENTO}{Name of the department (character)}
  \item{NOMBRE MUNICIPIO}{Name of the municipality (character)}
  \item{PDET}{PDET status (character)}
  \item{NOMBRE CENTRO POBLADO}{Name of the populated center (character)}
  \item{NOMBRE SEDE EDUCATIVA}{Name of the educational center (character)}
  \item{FECHA INICIO DE OPERACIÓN}{Start date of operation (character)}
  \item{FIN DE OPERACIÓN INICIAL}{End date of initial operation (character)}
  \item{ESTADO}{Current status of the center (character)}
}
}
\source{
Data obtained from GOV.CO Datos Abiertos: \url{https://www.datos.gov.co/Ciencia-Tecnolog-a-e-Innovaci-n/Centros-Digitales-Sucre-/pwyn-md8n/about_data}
}
\usage{
data(digital_centers_tbl_df)
}
\description{
This dataset, digital_centers_tbl_df, is a tibble containing information about
Digital Centers located in the department of Sucre. It includes details such as
department name, municipality name, PDET status, name of the populated center,
educational center name, start date of operation, end date of initial operation,
and current status. The dataset was obtained from GOV.CO Datos Abiertos, last
update on April 20, 2024.
}
\details{
The dataset name has been kept as 'digital_centers_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
ColombiAPI package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble object. The original content has not
been modified in any way.
}
