% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_colombia_regions.R
\name{get_colombia_regions}
\alias{get_colombia_regions}
\title{Get Colombia's Regions from API Colombia}
\source{
API Colombia: \url{https://api-colombia.com/api/v1/Region}
}
\usage{
get_colombia_regions()
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{id}: Region identifier (integer)
  \item \code{name}: Region name (character)
  \item \code{description}: Detailed description of the region (character)
}
}
\description{
Retrieves comprehensive information about Colombia's six natural regions from the API Colombia service.
This function fetches data including region names, descriptions, and identifiers for all Colombian regions:
Caribe, Pacífico, Orinoquía, Amazonía, Andina, and Insular.
}
\details{
This function sends a GET request to the API Colombia service.
If the API request fails or returns an error status code,
the function returns \code{NULL} with an informative message.
}
\note{
Requires internet connection.
}
\examples{
if (interactive()) {
  get_colombia_regions()
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{as_tibble}}
}
