% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utility.R
\name{Def_Control_Guess}
\alias{Def_Control_Guess}
\title{Automatically assigns missing guessing control values
\code{Def_Control_Guess} checks and assigns default values}
\usage{
Def_Control_Guess(guesses_control, a_n)
}
\arguments{
\item{guesses_control}{list of parameters to control how the guessing works}

\item{a_n}{list of initial parameter values, used to determine number of parameters}
}
\value{
returns a filled list
}
\description{
Automatically assigns missing guessing control values
\code{Def_Control_Guess} checks and assigns default values
}
\examples{
library(data.table)
guesses_control <- list("maxiter"=10,"guesses"=10,
    "loglin_min"=-1,"loglin_max"=1,"loglin_method"="uniform")
a_n <- c(0.1,2,1.3)
guesses_control <- Def_Control_Guess(guesses_control, a_n)

}
