% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utility.R
\name{factorize}
\alias{factorize}
\title{Splits a parameter into factors}
\usage{
factorize(df, col_list, verbose = 0)
}
\arguments{
\item{df}{a data.table containing the columns of interest}

\item{col_list}{an array of column names that should have factor terms defined}

\item{verbose}{integer valued 0-4 controlling what information is printed to the terminal. Each level includes the lower levels. 0: silent, 1: errors printed, 2: warnings printed, 3: notes printed, 4: debug information printed. Errors are situations that stop the regression, warnings are situations that assume default values that the user might not have intended, notes provide information on regression progress, and debug prints out C++ progress and intermediate results. The default level is 2 and True/False is converted to 3/0.}
}
\value{
returns a list with two named fields. df for the updated dataframe, and cols for the new column names
}
\description{
\code{factorize} uses user provided list of columns to define new parameter for each unique value and update the data.table.
Not for interaction terms
}
\examples{
library(data.table)
a <- c(0, 1, 2, 3, 4, 5, 6)
b <- c(1, 2, 3, 4, 5, 6, 7)
c <- c(0, 1, 2, 1, 0, 1, 0)
df <- data.table::data.table("a" = a, "b" = b, "c" = c)
col_list <- c("c")
val <- factorize(df, col_list)
df <- val$df
new_col <- val$cols

}
\seealso{
Other Data Cleaning Functions: 
\code{\link{Check_Iters}()},
\code{\link{Date_Shift}()},
\code{\link{Event_Count_Gen}()},
\code{\link{Event_Time_Gen}()},
\code{\link{Joint_Multiple_Events}()},
\code{\link{Replace_Missing}()},
\code{\link{Time_Since}()},
\code{\link{apply_norm}()},
\code{\link{gen_time_dep}()}
}
\concept{Data Cleaning Functions}
