% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{SBM_net}
\alias{SBM_net}
\title{Simulated functional and structural connectivity with nested 
hierarchical community structure}
\format{
A list containing five components:
\describe{
  \item{func_edges}{a dataframe containing 1233 rows and 3 columns: func_start_node,
    func_end_node, and func_weight. This dataframe describes the pairwise functional
    edge weights between nodes.}
  \item{str_edges}{a dataframe containing 453 rows and 3 columns: str_start_node,
    str_end_node, and str_weight. This dataframe describes the pairwise structural
    edge weights between nodes. There are fewer rows to this dataframe than func_edges
    as structural connectivity tends to be sparser than functional connectivity.}
  \item{vertexes}{a dataframe containing 80 rows and 5 columns: node_id, node_label,
    func_degree, str_degree, and community. The degree of a node is the sum of all edge
     weights connected to the node. In this simulated network, node_label is left as NA
     but, for other networks, a specific label may be used to denote additional information
     about the node. The community variable is left blank but is used by the \code{\link{hms}}
     algorithm.}
  \item{func_matrix}{an 80 x 80 matrix in the style of a network adjacency matrix. It
     contains the same information as func_edges, just in a wide, rather than long, format.}
  \item{str_matrix}{an 80 x 80 matrix in the style of a network adjacency matrix. It
     contains the same information as str_edges, just in a wide, rather than long, format.}
}
}
\usage{
SBM_net
}
\description{
A dataset containing multimodal network information simulated to emulate 
functional and structural brain connectivity data with a nested hierarchical
community structure. This dataset is a list containing five components in a
format used as an input to the \code{\link{hms}} function. The components,
and their associated variables, are as follows:
}
\keyword{datasets}
