% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/executeDdl.R
\name{executeDdl}
\alias{executeDdl}
\title{Generate and execute the DDL on a database}
\usage{
executeDdl(
  connectionDetails,
  cdmVersion,
  cdmDatabaseSchema,
  executeDdl = TRUE,
  executePrimaryKey = TRUE,
  executeForeignKey = TRUE,
  ...
)
}
\arguments{
\item{connectionDetails}{An object of class connectionDetails as created by the DatabaseConnector::createConnectionDetails function.}

\item{cdmVersion}{The version of the CDM you are creating, e.g. 5.3, 5.4}

\item{cdmDatabaseSchema}{The schema of the CDM instance where the DDL will be run. For example, this would be "ohdsi.dbo" when testing on sql server.}

\item{executeDdl}{Should the DDL be executed? TRUE or FALSE}

\item{executePrimaryKey}{Should the primary keys be added? TRUE or FALSE}

\item{executeForeignKey}{Should the foreign keys be added? TRUE or FALSE}

\item{...}{Other arguments passed on to DatabaseConnector::executeSql. (This allows the user to set the path to errorReportFile.)}
}
\value{
Writes the fully specified DDLs, primary keys, foreign keys, and indices to a file and then executes on a database.
}
\description{
This function will generate the DDL for a specific dbms and CDM version and
then execute the DDL on a database.
}
\examples{
\dontrun{
executeDdl(connectionDetails = connectionDetails,
           cdmVersion = "5.4",
           cdmDatabaseSchema = "myCdm")
}
}
