/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import net.infonode.docking.AbstractTabWindow;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.WindowTab;
import net.infonode.docking.drag.DockingWindowDragSource;
import net.infonode.docking.drag.DockingWindowDragger;
import net.infonode.docking.drag.DockingWindowDraggerProvider;
import net.infonode.docking.internal.WriteContext;
import net.infonode.docking.internalutil.ButtonInfo;
import net.infonode.docking.internalutil.CloseButtonInfo;
import net.infonode.docking.internalutil.DockButtonInfo;
import net.infonode.docking.internalutil.InternalDockingUtil;
import net.infonode.docking.internalutil.MaximizeButtonInfo;
import net.infonode.docking.internalutil.MinimizeButtonInfo;
import net.infonode.docking.internalutil.RestoreButtonInfo;
import net.infonode.docking.internalutil.UndockButtonInfo;
import net.infonode.docking.model.TabWindowItem;
import net.infonode.docking.model.ViewWriter;
import net.infonode.docking.properties.TabWindowProperties;
import net.infonode.properties.base.Property;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapTreeListener;
import net.infonode.properties.propertymap.PropertyMapWeakListenerManager;
import net.infonode.properties.util.PropertyChangeListener;
import net.infonode.tabbedpanel.TabAdapter;
import net.infonode.tabbedpanel.TabEvent;
import net.infonode.tabbedpanel.TabRemovedEvent;
import net.infonode.util.ArrayUtil;
import net.infonode.util.Direction;

public class TabWindow
extends AbstractTabWindow {
    private static final ButtonInfo[] buttonInfos = new ButtonInfo[]{new UndockButtonInfo(TabWindowProperties.UNDOCK_BUTTON_PROPERTIES), new DockButtonInfo(TabWindowProperties.DOCK_BUTTON_PROPERTIES), new MinimizeButtonInfo(TabWindowProperties.MINIMIZE_BUTTON_PROPERTIES), new MaximizeButtonInfo(TabWindowProperties.MAXIMIZE_BUTTON_PROPERTIES), new RestoreButtonInfo(TabWindowProperties.RESTORE_BUTTON_PROPERTIES), new CloseButtonInfo(TabWindowProperties.CLOSE_BUTTON_PROPERTIES)};
    private AbstractButton[] buttons;
    private PropertyChangeListener minimumSizePropertiesListener;
    private PropertyMapTreeListener buttonFactoryListener;

    public TabWindow() {
        this((DockingWindow)null);
    }

    public TabWindow(DockingWindow dockingWindow) {
        DockingWindow[] dockingWindowArray;
        if (dockingWindow == null) {
            dockingWindowArray = null;
        } else {
            DockingWindow[] dockingWindowArray2 = new DockingWindow[1];
            dockingWindowArray = dockingWindowArray2;
            dockingWindowArray2[0] = dockingWindow;
        }
        this(dockingWindowArray);
    }

    public TabWindow(DockingWindow[] dockingWindowArray) {
        this(dockingWindowArray, null);
    }

    protected TabWindow(DockingWindow[] dockingWindowArray, TabWindowItem tabWindowItem) {
        super(true, tabWindowItem == null ? new TabWindowItem() : tabWindowItem);
        this.buttons = new AbstractButton[buttonInfos.length];
        this.minimumSizePropertiesListener = new PropertyChangeListener(){

            public void propertyChanged(Property property, Object object, Object object2, Object object3) {
                TabWindow.this.revalidate();
            }
        };
        this.buttonFactoryListener = new PropertyMapTreeListener(){

            public void propertyValuesChanged(Map map) {
                TabWindow.this.doUpdateButtonVisibility(map);
            }
        };
        this.setTabWindowProperties(((TabWindowItem)this.getWindowItem()).getTabWindowProperties());
        PropertyMapWeakListenerManager.addWeakPropertyChangeListener(this.getTabWindowProperties().getMap(), TabWindowProperties.RESPECT_CHILD_WINDOW_MINIMUM_SIZE, this.minimumSizePropertiesListener);
        new DockingWindowDragSource(this.getTabbedPanel(), new DockingWindowDraggerProvider(){

            public DockingWindowDragger getDragger(MouseEvent mouseEvent) {
                if (!TabWindow.this.getWindowProperties().getDragEnabled()) {
                    return null;
                }
                Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), TabWindow.this.getTabbedPanel());
                return TabWindow.this.getTabbedPanel().tabAreaContainsPoint(point) ? (TabWindow.this.getChildWindowCount() == 1 ? TabWindow.this.getChildWindow(0) : TabWindow.this).startDrag(TabWindow.this.getRootWindow()) : null;
            }
        });
        this.initMouseListener();
        this.init();
        this.getTabbedPanel().addTabListener(new TabAdapter(){

            public void tabAdded(TabEvent tabEvent) {
                TabWindow.this.doUpdateButtonVisibility(null);
            }

            public void tabRemoved(TabRemovedEvent tabRemovedEvent) {
                TabWindow.this.doUpdateButtonVisibility(null);
            }
        });
        if (dockingWindowArray != null) {
            for (int i = 0; i < dockingWindowArray.length; ++i) {
                this.addTab(dockingWindowArray[i]);
            }
        }
        PropertyMapWeakListenerManager.addWeakTreeListener(this.getTabWindowProperties().getMap(), this.buttonFactoryListener);
    }

    public TabWindowProperties getTabWindowProperties() {
        return ((TabWindowItem)this.getWindowItem()).getTabWindowProperties();
    }

    protected void tabSelected(WindowTab windowTab) {
        super.tabSelected(windowTab);
        if (this.getUpdateModel()) {
            ((TabWindowItem)this.getWindowItem()).setSelectedItem(windowTab == null ? null : this.getWindowItem().getChildWindowContaining(windowTab.getWindow().getWindowItem()));
        }
    }

    protected void update() {
    }

    protected void updateButtonVisibility() {
        this.doUpdateButtonVisibility(null);
    }

    private void doUpdateButtonVisibility(Map map) {
        if (InternalDockingUtil.updateButtons(buttonInfos, this.buttons, null, this, this.getTabWindowProperties().getMap(), map)) {
            this.updateTabAreaComponents();
        }
        super.updateButtonVisibility();
    }

    protected int getTabAreaComponentCount() {
        return ArrayUtil.countNotNull(this.buttons);
    }

    protected void getTabAreaComponents(int n, JComponent[] jComponentArray) {
        for (int i = 0; i < this.buttons.length; ++i) {
            if (this.buttons[i] == null) continue;
            jComponentArray[n++] = this.buttons[i];
        }
    }

    protected void optimizeWindowLayout() {
        if (this.getWindowParent() == null) {
            return;
        }
        if (this.getTabbedPanel().getTabCount() == 0) {
            this.internalClose();
        } else if (this.getTabbedPanel().getTabCount() == 1 && (this.getWindowParent().showsWindowTitle() || !this.getChildWindow(0).needsTitleWindow())) {
            this.getWindowParent().internalReplaceChildWindow(this, this.getChildWindow(0).getBestFittedWindow(this.getWindowParent()));
        }
    }

    public int addTab(DockingWindow dockingWindow, int n) {
        int n2 = super.addTab(dockingWindow, n);
        this.setSelectedTab(n2);
        return n2;
    }

    protected int addTabNoSelect(DockingWindow dockingWindow, int n) {
        DockingWindow dockingWindow2 = n == this.getChildWindowCount() ? null : this.getChildWindow(n);
        int n2 = super.addTabNoSelect(dockingWindow, n);
        if (this.getUpdateModel()) {
            this.addWindowItem(dockingWindow, dockingWindow2 == null ? -1 : this.getWindowItem().getWindowIndex(this.getWindowItem().getChildWindowContaining(dockingWindow2.getWindowItem())));
        }
        return n2;
    }

    protected void updateWindowItem(RootWindow rootWindow) {
        super.updateWindowItem(rootWindow);
        ((TabWindowItem)this.getWindowItem()).setParentTabWindowProperties(rootWindow == null ? TabWindowItem.emptyProperties : rootWindow.getRootWindowProperties().getTabWindowProperties());
    }

    protected PropertyMap getPropertyObject() {
        return this.getTabWindowProperties().getMap();
    }

    protected PropertyMap createPropertyObject() {
        return new TabWindowProperties().getMap();
    }

    protected int getEdgeDepth(Direction direction) {
        return direction == this.getTabbedPanel().getProperties().getTabAreaOrientation() ? 1 : super.getEdgeDepth(direction);
    }

    protected int getChildEdgeDepth(DockingWindow dockingWindow, Direction direction) {
        return direction == this.getTabbedPanel().getProperties().getTabAreaOrientation() ? 0 : 1 + super.getChildEdgeDepth(dockingWindow, direction);
    }

    protected DockingWindow getOptimizedWindow() {
        return this.getChildWindowCount() == 1 ? this.getChildWindow(0).getOptimizedWindow() : super.getOptimizedWindow();
    }

    protected boolean acceptsSplitWith(DockingWindow dockingWindow) {
        return super.acceptsSplitWith(dockingWindow) && (this.getChildWindowCount() != 1 || this.getChildWindow(0) != dockingWindow);
    }

    protected DockingWindow getBestFittedWindow(DockingWindow dockingWindow) {
        return this.getChildWindowCount() == 1 && (!this.getChildWindow(0).needsTitleWindow() || dockingWindow.showsWindowTitle()) ? this.getChildWindow(0).getBestFittedWindow(dockingWindow) : this;
    }

    protected void write(ObjectOutputStream objectOutputStream, WriteContext writeContext, ViewWriter viewWriter) throws IOException {
        objectOutputStream.writeInt(3);
        viewWriter.writeWindowItem(this.getWindowItem(), objectOutputStream, writeContext);
        super.write(objectOutputStream, writeContext, viewWriter);
    }
}

