/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.action;

import java.awt.Point;
import java.io.ObjectStreamException;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.FloatingWindow;
import net.infonode.docking.action.DockingWindowAction;
import net.infonode.docking.util.DockingUtil;
import net.infonode.gui.icon.button.UndockIcon;

public class UndockWindowAction
extends DockingWindowAction {
    private static final long serialVersionUID = 1L;
    public static final UndockWindowAction INSTANCE = new UndockWindowAction();
    private static final Icon icon = new UndockIcon(10);

    private UndockWindowAction() {
    }

    public Icon getIcon() {
        return icon;
    }

    public String getName() {
        return "Undock";
    }

    public boolean isPerformable(DockingWindow dockingWindow) {
        if (dockingWindow.isUndockable()) {
            FloatingWindow floatingWindow = DockingUtil.getFloatingWindowFor(dockingWindow);
            return floatingWindow == null || floatingWindow.getChildWindowCount() > 0 && floatingWindow.getChildWindow(0) != dockingWindow && floatingWindow.getChildWindow(0).getChildWindowCount() > 1;
        }
        return false;
    }

    public void perform(DockingWindow dockingWindow) {
        if (this.isPerformable(dockingWindow)) {
            Point point = dockingWindow.getLocation();
            SwingUtilities.convertPointToScreen(point, dockingWindow.getParent());
            dockingWindow.undock(point);
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }
}

