/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import net.infonode.gui.layout.LayoutUtil;

public class BorderLayout2
implements LayoutManager2 {
    private Component[][] components = new Component[3][];

    public BorderLayout2() {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = new Component[3];
        }
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void addLayoutComponent(Component component, Object object) {
        if (!(object instanceof Point)) {
            throw new RuntimeException("BorderLayout2 constraint must be a Point!");
        }
        Point point = (Point)object;
        this.components[point.x][point.y] = component;
    }

    public float getLayoutAlignmentX(Container container) {
        return container.getAlignmentX();
    }

    public float getLayoutAlignmentY(Container container) {
        return container.getAlignmentY();
    }

    public void invalidateLayout(Container container) {
    }

    public Dimension maximumLayoutSize(Container container) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 3; ++i) {
            n += this.getMaximumWidth(i);
            n2 += this.getMaximumHeight(i);
        }
        return new Dimension(n, n2);
    }

    private int getPreferredHeight(int n) {
        int n2 = 0;
        for (int i = 0; i < 3; ++i) {
            int n3;
            Component component = this.components[i][n];
            if (component == null || !component.isVisible() || (n3 = component.getPreferredSize().height) <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    private int getPreferredWidth(int n) {
        int n2 = 0;
        for (int i = 0; i < 3; ++i) {
            int n3;
            Component component = this.components[n][i];
            if (component == null || !component.isVisible() || (n3 = component.getPreferredSize().width) <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    private int getMinimumHeight(int n) {
        int n2 = 0;
        for (int i = 0; i < 3; ++i) {
            int n3;
            Component component = this.components[i][n];
            if (component == null || !component.isVisible() || (n3 = component.getMinimumSize().height) <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    private int getMinimumWidth(int n) {
        int n2 = 0;
        for (int i = 0; i < 3; ++i) {
            int n3;
            Component component = this.components[n][i];
            if (component == null || !component.isVisible() || (n3 = component.getMinimumSize().width) <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    private int getMaximumHeight(int n) {
        int n2 = Integer.MAX_VALUE;
        for (int i = 0; i < 3; ++i) {
            int n3;
            Component component = this.components[i][n];
            if (component == null || !component.isVisible() || (n3 = component.getMaximumSize().height) >= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    private int getMaximumWidth(int n) {
        int n2 = 0;
        for (int i = 0; i < 3; ++i) {
            int n3;
            Component component = this.components[n][i];
            if (component == null || !component.isVisible() || (n3 = component.getMaximumSize().width) >= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    private static void setBounds(Component component, Rectangle rectangle) {
        int n = Math.min(component.getMaximumSize().width, rectangle.width);
        int n2 = Math.min(component.getMaximumSize().height, rectangle.height);
        Rectangle rectangle2 = new Rectangle(rectangle.x + (int)(component.getAlignmentX() * (float)(rectangle.width - n)), rectangle.y + (int)(component.getAlignmentY() * (float)(rectangle.height - n2)), n, n2);
        component.setBounds(rectangle2);
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = LayoutUtil.getInteriorSize(container);
        int[] nArray = new int[]{this.getPreferredWidth(0), this.getPreferredWidth(2)};
        int[] nArray2 = new int[]{this.getPreferredHeight(0), this.getPreferredHeight(2)};
        int n = insets.top;
        for (int i = 0; i < 3; ++i) {
            int n2 = i == 1 ? dimension.height - nArray2[0] - nArray2[1] : nArray2[i / 2];
            int n3 = insets.left;
            for (int j = 0; j < 3; ++j) {
                int n4 = j == 1 ? dimension.width - nArray[0] - nArray[1] : nArray[j / 2];
                Component component = this.components[j][i];
                if (component != null && component.isVisible()) {
                    BorderLayout2.setBounds(component, new Rectangle(n3, n, n4, n2));
                }
                n3 += n4;
            }
            n += n2;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 3; ++i) {
            n += this.getMinimumWidth(i);
            n2 += this.getMinimumHeight(i);
        }
        return new Dimension(n, n2);
    }

    public Dimension preferredLayoutSize(Container container) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 3; ++i) {
            n += this.getPreferredWidth(i);
            n2 += this.getPreferredHeight(i);
        }
        return new Dimension(n, n2);
    }

    public void removeLayoutComponent(Component component) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (this.components[i][j] != component) continue;
                this.components[i][j] = null;
                return;
            }
        }
    }
}

