/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.properties.propertymap.value;

import java.io.IOException;
import java.io.ObjectInputStream;
import net.infonode.properties.base.Property;
import net.infonode.properties.propertymap.PropertyMapImpl;
import net.infonode.properties.propertymap.value.PropertyRefValue;
import net.infonode.properties.propertymap.value.PropertyValue;
import net.infonode.properties.propertymap.value.SimplePropertyValue;

public class ValueDecoder {
    public static final int SIMPLE = 0;
    public static final int REF = 1;

    private ValueDecoder() {
    }

    public static PropertyValue decode(ObjectInputStream objectInputStream, PropertyMapImpl propertyMapImpl, Property property) throws IOException {
        int n = objectInputStream.readInt();
        switch (n) {
            case 0: {
                return SimplePropertyValue.decode(objectInputStream);
            }
            case 1: {
                return PropertyRefValue.decode(objectInputStream, propertyMapImpl, property);
            }
        }
        throw new IOException("Invalid value type!");
    }

    public static void skip(ObjectInputStream objectInputStream) throws IOException {
        int n = objectInputStream.readInt();
        switch (n) {
            case 0: {
                SimplePropertyValue.skip(objectInputStream);
                break;
            }
            case 1: {
                PropertyRefValue.skip(objectInputStream);
                break;
            }
            default: {
                throw new IOException("Invalid value type!");
            }
        }
    }
}

