/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.action;

import net.infonode.docking.DockingWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.action.DockingWindowAction;
import net.infonode.docking.action.MaximizeWindowAction;
import net.infonode.docking.action.MaximizeWithAbortWindowAction;
import net.infonode.docking.action.RestoreParentWindowAction;
import net.infonode.docking.action.RestoreParentWithAbortWindowAction;
import net.infonode.docking.util.DockingUtil;

public class StateDependentWindowAction
extends DockingWindowAction {
    private static final long serialVersionUID = 1L;
    public static final StateDependentWindowAction MAXIMIZE_RESTORE = new StateDependentWindowAction(MaximizeWindowAction.INSTANCE, RestoreParentWindowAction.INSTANCE, RestoreParentWindowAction.INSTANCE);
    public static final StateDependentWindowAction MAXIMIZE_RESTORE_WITH_ABORT = new StateDependentWindowAction(MaximizeWithAbortWindowAction.INSTANCE, RestoreParentWithAbortWindowAction.INSTANCE, RestoreParentWithAbortWindowAction.INSTANCE);
    private DockingWindowAction normalAction;
    private DockingWindowAction minimizedAction;
    private DockingWindowAction maximizedAction;

    public StateDependentWindowAction(DockingWindowAction dockingWindowAction, DockingWindowAction dockingWindowAction2, DockingWindowAction dockingWindowAction3) {
        this.normalAction = dockingWindowAction;
        this.minimizedAction = dockingWindowAction2;
        this.maximizedAction = dockingWindowAction3;
    }

    public String getName() {
        return "State Dependent";
    }

    public boolean isPerformable(DockingWindow dockingWindow) {
        return this.getActionProvider(dockingWindow).isPerformable(dockingWindow);
    }

    public void perform(DockingWindow dockingWindow) {
        this.getActionProvider(dockingWindow).perform(dockingWindow);
    }

    private DockingWindowAction getActionProvider(DockingWindow dockingWindow) {
        if (dockingWindow.isMinimized()) {
            return this.minimizedAction;
        }
        TabWindow tabWindow = DockingUtil.getTabWindowFor(dockingWindow);
        return tabWindow != null && tabWindow.isMaximized() ? this.maximizedAction : this.normalAction;
    }
}

