/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.drag;

import javax.swing.JComponent;
import net.infonode.docking.drag.DockingWindowDragger;
import net.infonode.docking.drag.DockingWindowDraggerProvider;
import net.infonode.gui.draggable.DraggableComponent;
import net.infonode.gui.draggable.DraggableComponentAdapter;
import net.infonode.gui.draggable.DraggableComponentEvent;

public class DockingWindowDragSource {
    private final DraggableComponent draggableComponent;
    private DockingWindowDragger dragger;

    public DockingWindowDragSource(JComponent jComponent, final DockingWindowDraggerProvider dockingWindowDraggerProvider) {
        this.draggableComponent = new DraggableComponent(jComponent);
        this.draggableComponent.setReorderEnabled(false);
        this.draggableComponent.setEnableInsideDrag(true);
        this.draggableComponent.addListener(new DraggableComponentAdapter(){

            public void dragAborted(DraggableComponentEvent draggableComponentEvent) {
                DockingWindowDragSource.this.abortDrag();
            }

            public void dragged(DraggableComponentEvent draggableComponentEvent) {
                if (DockingWindowDragSource.this.dragger == null) {
                    DockingWindowDragSource.this.dragger = dockingWindowDraggerProvider.getDragger(draggableComponentEvent.getMouseEvent());
                    if (DockingWindowDragSource.this.dragger == null) {
                        DockingWindowDragSource.this.draggableComponent.abortDrag();
                        return;
                    }
                    DockingWindowDragSource.this.draggableComponent.setAbortDragKeyCode(DockingWindowDragSource.this.dragger.getDropTarget().getRootWindowProperties().getAbortDragKey());
                }
                DockingWindowDragSource.this.dragger.dragWindow(draggableComponentEvent.getMouseEvent());
            }

            public void dropped(DraggableComponentEvent draggableComponentEvent) {
                if (DockingWindowDragSource.this.dragger != null) {
                    DockingWindowDragSource.this.dragger.dropWindow(draggableComponentEvent.getMouseEvent());
                    DockingWindowDragSource.this.dragger = null;
                }
            }
        });
    }

    public void abortDrag() {
        if (this.dragger != null) {
            this.dragger.abortDrag();
        }
        this.dragger = null;
    }
}

