% Generated by roxygen2 (4.0.1): do not edit by hand
\name{dcomp}
\alias{dcomp}
\title{Conway-Maxwell-Poisson Probability Density Function}
\usage{
dcomp(y, lam, nu, sumTo = 100L, logP = FALSE)
}
\arguments{
\item{y}{an integer vector where the density is to be calculated. If the input is not an
integer, it will be coerced to be an integer.}

\item{lam}{a double vector of the parameter \eqn{\lambda}.}

\item{nu}{a double vector of the parameter \eqn{\nu}.}

\item{sumTo}{an integer for the summation term in the density (default 100).}

\item{logP}{a boolean for if the log of the density should be given (default \code{FALSE}).}
}
\value{
The value of the PDF (or log PDF if \code{logP = TRUE}). Input vectors
are recycled to be same length.
}
\description{
The PDF of the Conway-Maxwell-Poisson distribution with
parameters \code{lam} and \code{nu} at point \code{y}.
}
\details{
The Conway-Maxwell-Poisson distribution has density:
\deqn{P(y) = \frac{\lambda^y}{(y!)^\nu Z(\lambda, \nu)}}{%
	  P(y) = \lambda^y / ((y!)^\nu Z(\lambda, \nu))}
      for \eqn{y = 0, 1, 2, \ldots},  and:
\deqn{Z(\lambda, \nu) = \sum_{j=0}^\infty \frac{\lambda^j}{(j!)^\nu}}{%
      Z(\lambda, \nu) = \sum \lambda^j / ((j!)^\nu)}
where the summation is approximated by summing from \code{j = 0} to \code{sumTo}.
}
\examples{
dcomp(-5:5, 2.5, 1)
dcomp(2, 2.5, 1.5)
require(graphics)
require(stats)
comp <- dcomp(0:10, 2.5, 0.9)
poisson <- dpois(0:10, 2.5)
barplot(rbind(comp, poisson), beside = TRUE, names= 0:10, legend.text = TRUE)
}
\author{
Jeffrey Pollock <jeffpollock9@gmail.com>
}

