% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{Fcomp_Model}
\alias{Fcomp_Model}
\title{Simulation for functional composition data.}
\usage{
Fcomp_Model(n, p, m = 0, intercept = TRUE,
            interval = c(0, 1), n_T = 100, obs_spar = 0.6, discrete = FALSE,
            SNR = 1, sigma = 2, Nzero_group = 4,
            rho_X, Corr_X = c("CorrCS", "CorrAR"),
            rho_T, Corr_T = c("CorrAR", "CorrCS"),
            range_beta = c(0.5, 1), beta_c = 1, beta_C ,
            theta.add = c(1, 2, 5, 6), gamma = 0.5,
            basis_beta = c("bs", "OBasis", "fourier"), df_beta = 5, degree_beta = 3,
            insert = c("FALSE", "X", "basis"), method = c("trapezoidal", "step"))
}
\arguments{
\item{n}{sample size.}

\item{p}{number of the components in the functional compositional data.}

\item{m}{size of unpenalized variables.
The first \code{ceiling(m/2)} ones are generated with independent \code{bin(1,0.5)} entries;
while the last \code{(m - ceiling(m/2))} ones are generated with independent \code{norm(0, 1)} entries.
Default is 0.}

\item{intercept}{whether to include an intercept.
Default is \code{TRUE}.}

\item{interval}{a vector of length 2 indicating the time domain. Default is \code{c(0, 1)}.}

\item{n_T}{an integer specifying length of the equally spaced time sequence on domian \code{interval}.}

\item{obs_spar}{a percentage used to get sparse ovbservation. Each time point is with
probability \code{obs_spar} to be observed. It allows different subject to be observed on
different time points.
\code{obs_spar * n_T > 5} is required.}

\item{discrete}{logical (default is \code{FALSE}) specifying whether the functional compositional data
\eqn{X} is generated at different time points.
If \code{distrete = TRUE}, generate \eqn{X} on dense sequence created by
\code{max(ns_dense = 200 * diff(interval), 5 * n_T)} and then for
each subject, randomly sample \code{n_T} points.}

\item{SNR}{signal to noise ratio.}

\item{sigma}{variance used to generate the covariance matrix
\code{CovMIX = sigma^2 * kronecker(T.Sigma, X.Sigma)}.
The "non-normalized" data \eqn{w_{i}}{w_i} for each subject is
genearted from multivariate normal distribution with covariance \code{CovMIX}.
\code{T.Sigma} and \code{X.Sigma} are correlation matrices for
time points and components, respectively.}

\item{Nzero_group}{an even integer specifying that the first \code{Nzero_group} compositional predictors
are with non-zero effects. Default is 4.}

\item{rho_X, rho_T}{parameters used to generate correlation matrices.}

\item{Corr_X, Corr_T}{character string specifying correlation structure
bewteen components and between time points, respectively.
\itemize{
\item \code{"CorrCS"}(Default for \code{Corr_X}) compound symmetry.
\item \code{"CorrAR"}(Default for \code{Corr_T}) autoregressive.
}}

\item{range_beta}{a sorted vector of length 2, specifying the range of coefficient
matrix \code{B} of demension \eqn{p \times k}{p*k}.
Specifically, each column of \code{B} is filled with \code{Nzero_group/2} values
from the unifom distribution over \code{range_beta} and their negative counterparts.
Default is \code{c(0.5, 1)}.}

\item{beta_c}{value of coefficients for beta0 and beta_c (coefficients for intercept and time-invariant predictors).
Default is 1.}

\item{beta_C}{vectorized coefficient matrix.
If missing, the program will generate \code{beta_C} according to \code{range_beta}
and \code{Nzero_group}.}

\item{theta.add}{logical or integer(s).
\itemize{
\item If integer(s), a vector with value(s) in \code{[1,p]},
      indicating which component(s) of compostions is of high
      level mean curve.
\item If \code{TRUE},
      the components \code{c(1:ceiling(Nzero_group/2)} and
      \code{Nzero_group + (1:ceiling(Nzero_group/2)))}
      are set to with high level mean.
\item if \code{FALSE}, all mean curves are set to 0's.
}}

\item{gamma}{for the high-level mean groups, log(p * gamma) is added on the "non-normalized"
data \eqn{w_{i}}{w_i} before the data are converted to be compositional.}

\item{basis_beta, df_beta, degree_beta}{\code{basis_fun}, \code{k} and \code{degree}
in \code{\link{FuncompCGL}} respectively.}

\item{insert}{a character string sepcifying method to perform functional interpolation.
\itemize{
\item \code{"FALSE"}(Default) no interpolation.
\item \code{"X"} linear interpolation of functional compositional
      data along the time grid.
\item \code{"basis"} the functional compositional data is interplolated
      as a step function along the time grid.
}
If \code{insert} = \code{"X"} or \code{"basis"}, interplolation is conducted
on \code{sseq}, where \code{sseq} is the sorted sequence of all the observed time points.}

\item{method}{a character string sepcifying method used to approximate integral.
\itemize{
\item \code{"trapezoidal"}(Default) Sum up areas under the trapezoids.
\item \code{"step"} Sum up area under the rectangles.
}}
}
\value{
a list including
\item{data}{a list of observed data,
            \itemize{
            \item \code{y} a vector of response variable,
            \item \code{Comp} a data frame of observed functional compositional
                              data, a column of \code{Subject_ID}, and a
                              column of \code{TIME},
            \item \code{Zc} a matrix of unpenalized variables with dimension
                            \eqn{n \times m}{n*m},
            \item \code{intercept} whether an \code{intercept}
                                   is included.
            }}

\item{beta}{a length \code{p*df_beta + m + 1} vector of coefficients}
\item{basis.info}{matrix of the basis function to generate the coefficient curves}

\item{data.raw}{ a list consisting of
                \itemize{
                \item \code{Z_t.full} the functional compositional data.
                \item \code{Z_ITG} integrated functional compositional data.
                \item \code{Y.tru} true response vector without noise.
                \item \code{X} functional "non-normalized" data \code{W}.
                }}

\item{parameter}{a list of parameters used in the simulation.}
}
\description{
simulate functional compositional data.
}
\details{
The setup of this simulation follows
Sun, Z., Xu, W., Cong, X., Li G. and Chen K. (2020) \emph{Log-contrast regression with
functional compositional predictors: linking preterm infant's gut microbiome trajectories
to neurobehavioral outcome}, \href{https://arxiv.org/abs/1808.02403}{https://arxiv.org/abs/1808.02403}
\emph{Annals of Applied Statistics}.
\cr
Specifically, we first generate correlation matrix \code{X.sigma} for components of a composition
based on \code{rho_X} and \code{Corr_X}, and correlation matrix \code{T.sigma}
for time points based on \code{rho_T} and \code{Corr_T}. Then, the "non-normalized"
data \eqn{w_i=[w_i(t_1)^T,...,w_i(t_{n_T})^T]}
for each subject are generated from multivariate normal
distrubtion with covariance \code{CovMIX = sigma^2 * kronecker(T.Sigma, X.Sigma)}, and
the mean vector is determined by \code{theta.add} and \code{gamma}.
Each \eqn{w_i(t_v)} is a \code{p}-vector for each time point \eqn{v =1,...,T_n}.
Finally, the compositional data are obtained as
\deqn{
x_{ij}(t_v) = exp(w_{ij}(t_v))/sum_{k=1}^{p} exp(w_{ik}(t_v)),
}
for each subject \eqn{i=1,...,n}, component of a composition \eqn{j=1,...,p}
and time point \eqn{v=1,...,n_T}.
}
\examples{
Data <- Fcomp_Model(n = 50, p = 30, m = 0, intercept = TRUE, Nzero_group = 4,
                    n_T = 20, SNR = 3, rho_X = 0, rho_T = 0.6,
                    df_beta = 5, obs_spar = 1, theta.add = FALSE)

}
\references{
Sun, Z., Xu, W., Cong, X., Li G. and Chen K. (2020) \emph{Log-contrast regression with
functional compositional predictors: linking preterm infant's gut microbiome trajectories
to neurobehavioral outcome}, \href{https://arxiv.org/abs/1808.02403}{https://arxiv.org/abs/1808.02403}
\emph{Annals of Applied Statistics}
}
\author{
Zhe Sun and Kun Chen
}
