% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{coef.cv.FuncompCGL}
\alias{coef.cv.FuncompCGL}
\title{Extract estiamted coefficients from a \code{"cv.FuncompCGL"} object.}
\usage{
\method{coef}{cv.FuncompCGL}(object, trim = FALSE, s = c("lam.min", "lam.1se"), k = NULL, ...)
}
\arguments{
\item{object}{fitted \code{\link{cv.FuncompCGL}} object.}

\item{trim}{logical; whether to use the trimmed result. Default is \code{FALSE}.}

\item{s}{value(s) of the penalty parameter \code{lam} at which coefficients are requested.
\itemize{
\item \code{s="lam.min"}(default), grid value of
\code{lam} and \code{k} stored in the \code{"cv.FuncompCGL"} object
such that the minimum cross-validation error is achieved.
\item \code{s="lam.1se"}, grid value of
\code{lam} and \code{k} stored on the \code{"cv.FuncompCGL"} object
such that the 1 standard error above the miminum cross-validation error is achieved.
\item If \code{s} is numeric, it is taken as the value(s) of \code{lam} to be used. In this
case, \code{k} must be provided.
\item If \code{s = NULL}, the whole sequence of \code{lam} stored in the \code{cv.FuncompCGL}
      object is used.
}}

\item{k}{value(s) of the degrees of freedom of the basis function at which coefficents are requested.
\code{k} can be \code{NULL} (default) or integer(s).
\itemize{
\item \code{k = NULL}, \code{s} must be either \code{"lam.min"} or \code{"lam.1se"}.
\item if \code{k} is an integer(s), it is taken as the value of \code{k} to be used and
      it must be one(s) of these in the \code{"cv.FuncompCGL"} object.
}}

\item{\dots}{not used.}
}
\value{
The coefficients at the requested values of \code{s} and \code{k}.
If \code{k} is a vector, a list of coefficient matrices is returned.
}
\description{
This function gets the coefficients from a cross-validated
\code{FuncompCGL} model, using the stored \code{"FuncompCGL.fit"} object,
and the optimal grid values of the penalty parameter \code{lam} and the degrees of freedom \code{k}.
}
\details{
\code{s} is a vector of lambda values at which the coefficients are requested. If \code{s} is not in the
\code{lam} sequence used for fitting the model, the \code{coef} function will use linear
interpolation, so the function should be used with caution.
}
\examples{
\donttest{
df_beta = 5
p = 30
beta_C_true = matrix(0, nrow = p, ncol = df_beta)
beta_C_true[1, ] <- c(-0.5, -0.5, -0.5 , -1, -1)
beta_C_true[2, ] <- c(0.8, 0.8,  0.7,  0.6,  0.6)
beta_C_true[3, ] <- c(-0.8, -0.8 , 0.4 , 1 , 1)
beta_C_true[4, ] <- c(0.5, 0.5, -0.6  ,-0.6, -0.6)
Data <- Fcomp_Model(n = 50, p = p, m = 0, intercept = TRUE,
                    SNR = 4, sigma = 3, rho_X = 0, rho_T = 0.6, df_beta = df_beta,
                    n_T = 20, obs_spar = 1, theta.add = FALSE,
                    beta_C = as.vector(t(beta_C_true)))

cv_m1 <-  cv.FuncompCGL(y = Data$data$y, X = Data$data$Comp,
                        Zc = Data$data$Zc, intercept = Data$data$intercept,
                        k = c(4,5), nfolds = 5, nlam = 50,
                        keep = TRUE)
coef(cv_m1)
coef(cv_m1, s = "lam.1se")
coef(cv_m1, s = c(0.5, 0.1, 0.05), k = c(4,5))
coef(cv_m1, s = NULL, k = c(4,5))
}

}
\references{
Sun, Z., Xu, W., Cong, X., Li G. and Chen K. (2020) \emph{Log-contrast regression with
functional compositional predictors: linking preterm infant's gut microbiome trajectories
to neurobehavioral outcome}, \href{https://arxiv.org/abs/1808.02403}{https://arxiv.org/abs/1808.02403}
\emph{Annals of Applied Statistics}
}
\seealso{
\code{\link{cv.FuncompCGL}} and \code{\link{FuncompCGL}}, and
\code{\link[=predict.cv.FuncompCGL]{predict}} and
\code{\link[=plot.cv.FuncompCGL]{plot}} methods for \code{"cv.FuncompCGL"} object.
}
\author{
Zhe Sun and Kun Chen
}
