% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{plot.GIC.compCL}
\alias{plot.GIC.compCL}
\title{Plot the GIC curve produced by \code{"GIC.compCL"} object.}
\usage{
\method{plot}{GIC.compCL}(x, xlab = c("log", "-log", "lambda"), ...)
}
\arguments{
\item{x}{fitted \code{"GIC.compCL"} object.}

\item{xlab}{what is on the X-axis,
\code{"log"} plots against \code{log(lambda)} (default),
\code{"-log"} against \code{-log(lambda)}, and \code{"lambda"} against \code{lambda}.}

\item{...}{other graphical parameters.}
}
\value{
No return value. Side effect is a base R plot.
}
\description{
Plot the CIC curve as a function of the \code{lam} values.
}
\details{
A GIC curve is produced.
}
\examples{
p = 30
n = 50
beta = c(1, -0.8, 0.6, 0, 0, -1.5, -0.5, 1.2)
beta = c(beta, rep(0, times = p - length(beta)))
Comp_data = comp_Model(n = n, p = p, beta = beta, intercept = FALSE)
GICm1 <- GIC.compCL(y = Comp_data$y, Z = Comp_data$X.comp,
                    Zc = Comp_data$Zc, intercept = Comp_data$intercept)
plot(GICm1)
plot(GICm1, xlab = "-log")

}
\references{
Lin, W., Shi, P., Peng, R. and Li, H. (2014) \emph{Variable selection in
regression with compositional covariates},
\href{https://academic.oup.com/biomet/article/101/4/785/1775476}{https://academic.oup.com/biomet/article/101/4/785/1775476}.
\emph{Biometrika} \strong{101} 785-979.
}
\seealso{
\code{\link{GIC.compCL}} and \code{\link{compCL}}, and
\code{\link[=predict.GIC.compCL]{predict}} and
\code{\link[=coef.GIC.compCL]{coef}} methods for \code{"GIC.compCL"} object.
}
\author{
Zhe Sun and Kun Chen
}
