% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_Meaco.R
\name{tidy_Meaco}
\alias{tidy_Meaco}
\title{Tidy Meaco sensor data}
\usage{
tidy_Meaco(
  mydata,
  Site_col = "RECEIVER",
  Sensor_col = "TRANSMITTER",
  Date_col = "DATE",
  Temp_col = "TEMPERATURE",
  RH_col = "HUMIDITY"
)
}
\arguments{
\item{mydata}{A data frame containing raw Meaco sensor data with columns
RECEIVER, TRANSMITTER, DATE, TEMPERATURE, and HUMIDITY}

\item{Site_col}{A string specifying the name of the column in `mydata` that contains
location information. Default is "RECEIVER".}

\item{Sensor_col}{A string specifying the name of the column in `mydata` that contains
sensor information. Default is "TRANSMITTER".}

\item{Date_col}{A string specifying the name of the column in `mydata` that contains
date information. Default is "DATE".}

\item{Temp_col}{A string specifying the name of the column in `mydata` that contains
temperature data. Default is "TEMPERATURE".}

\item{RH_col}{A string specifying the name of the column in `mydata` that contains
relative humidity data. Default is "HUMIDITY".}
}
\value{
A tidied data frame with columns Site, Sensor, Date, Temp, and RH
}
\description{
This function takes raw Meaco sensor data and performs several cleaning and processing steps:

\itemize{
   \item Filters out rows with missing dates
   \item Renames column names for consistency
   \item Converts temperature and relative humidity to numeric
   \item Rounds dates down to the nearest hour
   \item Calculates hourly averages for temperature and relative humidity
   \item Pads the data to ensure hourly intervals using padr package
   \item Filters out unrealistic temperature and humidity values
         (outside -50°C to 50°C and 0 to 100\%RH)
}
}
\examples{

\donttest{
# Example usage: meaco_data <- tidy_Meaco("path/to/your/meaco_data.csv")
}



}
