% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\encoding{UTF-8}
\name{gammaParamsConvert}
\alias{gammaParamsConvert}
\title{Gamma distribution shape and scale parameters from mean and standard 
deviation, or vice-versa}
\usage{
gammaParamsConvert(...)
}
\arguments{
\item{\dots}{This function can be run either supplying \code{mean} and
\code{sd}, or supplying \code{shape} and \code{scale}, but not both pairs
of parameters.}
}
\value{
A list with \code{mean}, \code{sd}, \code{shape} and \code{scale} 
  parameters of the corresponding gamma distribution.
}
\description{
Calculates shape and scale parameters for a gamma distribution from the mean 
and standard deviation of the distribution, or vice-versa.  One supplies 
either \code{mean} and \code{sd} or \code{shape} and \code{scale} and the 
function returns a list with all four parameter values.
}
\examples{
library(ConnMatTools)
mn <- 1
sd <- 0.4
l <- gammaParamsConvert(mean=mn,sd=sd)
x <- seq(0,2,length.out=50)

# Plot gamma and normal distributions - for sd << mean, the two should be very close
plot(x,dgamma(x,l$shape,scale=l$scale),
     main="Normal versus Gamma distributions",type="l")
lines(x,dnorm(x,l$mean,l$sd),col="red")
}
\author{
David M. Kaplan \email{dmkaplan2000@gmail.com}
}

