% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InclusiveConnectedness.R
\name{InclusiveConnectedness}
\alias{InclusiveConnectedness}
\title{Inclusive Connectedness Measures}
\usage{
InclusiveConnectedness(
  dca,
  group = c(1, 2),
  start = NULL,
  end = NULL,
  corrected = FALSE
)
}
\arguments{
\item{dca}{Dynamic connectedness object}

\item{group}{Vector of group indices}

\item{start}{Start index}

\item{end}{End index}

\item{corrected}{Boolean value whether corrected or standard TCI should be computed}
}
\value{
Get connectedness measures
}
\description{
This function results in inclusive connectedness measures
}
\examples{
\donttest{
data("cegg2022")
dca = ConnectednessApproach(cegg2022,
                            model="TVP-VAR",
                            connectedness="Time",
                            nlag=1,
                            nfore=20,
                            corrected=TRUE,
                            VAR_config=list(TVPVAR=list(kappa1=0.99, 
                            kappa2=0.99, prior="BayesPrior")))
inc = InclusiveConnectedness(dca, group=c(1,2,3), corrected=TRUE)
}
}
\references{
Chatziantoniou, I., Elsayed, A., Gabauer, D., & Gozgor, G. (2022). Oil price shocks and exchange rate dynamics: New evidence from decomposed and partial connectedness measures for oil importing and exporting economies.
}
\author{
David Gabauer
}
