% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CC_without_robScore_functions.R
\name{multiview_cluster_gen}
\alias{multiview_cluster_gen}
\title{Multiview cluster generation}
\usage{
multiview_cluster_gen(
  X,
  func,
  rep = 10,
  param,
  is.distance = FALSE,
  sample.set = NA
)
}
\arguments{
\item{X}{List of input data matrices of Sample x feature or distance matrices.
The length of \code{X} is equal to Nviews}

\item{func}{custom function that accepts \code{X} and a parameter that return a vector of clusterings.
\code{cluster_func <- function(X, param)}}

\item{rep}{number of repeats}

\item{param}{vector of parameters}

\item{is.distance}{binary balue indicating if the input \code{X[i]} is distance}

\item{sample.set}{vector of samples the clustering is being applied on. can be names or indices.
if \code{sample.set} is \code{NA}, it considers all the datasets have the same samples with the same order}
}
\value{
matrix of clusterings Nsample x (Nrepeat x Nviews)
}
\description{
Multiview cluster generation
}
\details{
At each repeat, k is selected randomly or based on the best silhouette width from a discrete uniform distribution between range.k[1] and range.k[2].
Then clustering is applied and result is returned.
}
\examples{
data = multiview_clusters (n = c(40,40,40), hidden.dim = 2, observed.dim = c(2,2,2),
sd.max = .1, sd.noise = 0, hidden.r.range = c(.5,1))
X_observation = data[["observation"]]
cluster_func = function(X,rep,param){return(multi_kmeans_gen(X,rep=rep,range.k=param))}
Clusters = multiview_cluster_gen(X_observation, func = cluster_func, rep = 10, param = c(2,4))

}
