% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_generation_functions.R
\name{multiview_clusters}
\alias{multiview_clusters}
\title{Generate multiview clusters from Gaussian distributions with randomly generated parameters}
\usage{
multiview_clusters(
  n = c(50, 50),
  hidden.dim = 2,
  observed.dim = c(2, 2, 3),
  sd.max = 0.1,
  sd.noise = 0.01,
  hidden.r.range = c(0.1, 1)
)
}
\arguments{
\item{n}{vector of number of data points in each cluster
The length of \code{n} should be equal to the number of clusters.}

\item{hidden.dim}{scaler value of dimensions of the hidden state}

\item{observed.dim}{vector of number of dimensions of the generate clusters.
The length of \code{observed.dim} should be equal to the number of clusters.}

\item{sd.max}{maximum standard deviation of clusters}

\item{sd.noise}{standard deviation of the added noise}

\item{hidden.r.range}{the range (min, max) of distance of cluster centers from the origin in the hidden space.}
}
\value{
a list of data points (X) and cluster labels (class)
}
\description{
Generate multiview clusters from Gaussian distributions with randomly generated parameters
}
\examples{
data = multiview_clusters()

}
