% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConsensusOPLS.R
\name{ConsensusOPLS}
\alias{ConsensusOPLS}
\title{ConsensusOPLS}
\usage{
ConsensusOPLS(
  data,
  Y,
  maxPcomp = 1,
  maxOcomp = 5,
  modelType = "da",
  nperm = 100,
  cvType = "nfold",
  nfold = 5,
  nMC = 100,
  cvFrac = 4/5,
  kernelParams = list(type = "p", params = c(order = 1)),
  mc.cores = 1,
  verbose = FALSE
)
}
\arguments{
\item{data}{A list of data blocks. Each element of the list must be of matrix 
type. Rows and columns can be identified (names), in which case this will be 
retained during analysis. Any pre-processing of the data (e.g. scaling) must 
be carried out before building the model.}

\item{Y}{A vector, factor, dummy matrix or numeric matrix for the response. 
The type of answer given will condition the model to be used: a numeric 
vector for linear regression, a factor or dummy matrix for logistic 
regression or a discriminant model.}

\item{maxPcomp}{Maximum number of Y-predictive components used to build the 
optimal model. Default, 1.}

\item{maxOcomp}{Maximum number of Y-orthogonal components used to build the 
optimal model. Default, 5.}

\item{modelType}{String for type of OPLS regression model, either \code{reg} 
for regression or \code{da} for discriminant analysis. Default, \code{da}.}

\item{nperm}{Number of random permutations desired in response Y. Default, 
100.}

\item{cvType}{String for type of cross-validation used. Either \code{nfold} 
for n-fold cross-validation, where \code{nfold} is look up, or \code{mccv} 
for Monte Carlo cross-validation, or \code{mccvb} for Monte Carlo 
class-balanced cross-validation, where \code{nMC} and \code{cvFrac} are used.
Default, \code{nfold}, i.e. \code{nMC} and \code{cvFrac} are ignored.}

\item{nfold}{Number of folds performed in n-fold cross-validation. This can 
be set to the number of samples to perform Leave-One-Out cross validation. 
Default, 5.}

\item{nMC}{An integer indicating the number of rounds performed when 
\code{cvType} is \code{mccv} or \code{mccvb}. Default, 100.}

\item{cvFrac}{A numeric value indicating the fraction of observations from 
\code{data} used in the training set for \code{mccv} or \code{mccvb} 
cross-validation. Default, 4/5 = 0.8.}

\item{kernelParams}{List of parameters for the kernel. Either \code{p}
for polynomial kernel, which implies specifying the order of the polynomial 
by the \code{order} parameter, or \code{g} for Gaussian kernel. Default, 
\code{list(type='p', params = c(order=1.0))}.}

\item{mc.cores}{Number of cores for parallel computing. Default, 1.}

\item{verbose}{A logical indicating if detailed information (cross
validation) will be shown. Default, FALSE.}
}
\value{
An object of class \code{ConsensusOPLS} representing the consensus
OPLS model fit.
}
\description{
Constructs the consensus OPLS model with the optimal number of orthogonal 
components for given data blocks and response, and evaluate the model 
quality w.r.t other models built with randomly permuted responses.
}
\examples{
data(demo_3_Omics)
datablocks <- lapply(demo_3_Omics[c("MetaboData", "MicroData", "ProteoData")], scale)
res <- ConsensusOPLS(data=datablocks, 
                     Y=demo_3_Omics$Y,
                     maxPcomp=1, maxOcomp=2, 
                     modelType='da',
                     nperm=5)
res
}
