% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeClubs.R
\name{mergeClubs}
\alias{mergeClubs}
\title{Merge convergence clubs}
\usage{
mergeClubs(clubs, time_trim, mergeMethod = c("PS", "vLT"),
  mergeDivergent = FALSE, threshold = -1.65)
}
\arguments{
\item{clubs}{an object of class \code{convergence.clubs} (created by findClubs function)}

\item{time_trim}{a numeric value between 0 and 1, representing the portion of
time periods to trim when running log t regression model; if omitted, the same
value used for \code{clubs} is used.}

\item{mergeMethod}{character string indicating the merging method to use. Methods
available are \code{"PS"} for Phillips and Sul (2009) and \code{"vLT"} for
von Lyncker and Thoennessen (2016).}

\item{mergeDivergent}{logical, if TRUE, indicates that merging of divergent regions
should be tried.}

\item{threshold}{a numeric value indicating the threshold to be used with the t-test.}
}
\value{
Ad object of class \code{convergence.clubs}, containing a list of
Convergence Clubs, for each club a list is return with the
following objects: \code{id}, a vector containing the row indices
of the regions in the club; \code{model}, a list containing information
about the model used to run the t-test on the regions in the club;
\code{regions}, a vector containing the names of the regions of the club (optional,
only included if parameter \code{regions} is given)
}
\description{
Merges a list of clubs created with the function findClubs
by either Phillips and Sul method or von Lyncker and Thoennessen procedure.
}
\details{
Phillips and Sul (2009) suggest a "club merging algorithm" to avoid
over determination due to the selection of the parameter \eqn{c^*}{c*}.
This algorithm suggests to merge for adjacent groups. In particular, it works as follows:
\enumerate{
    \item Take the first two groups detected in the basic clustering mechanism
    and run the log-t test. If the t-statistic is larger than -1.65,
    these groups together form a new convergence club;
    \item Repeat the test adding the next group and continue until the
    basic condition (t-statistic > -1.65) holds;
    \item If convergence hypothesis is rejected, conclude that all previous groups
    converge, except the last one. Hence, start again the test merging algorithm
    beginning from the group for which the hypothesis of convergence did not hold.
    On the other hand, von Lyncker and Thoennessen (2016), propose a modified version
     of the club merging algorithm that works as follows:
        \enumerate{
            \item Take all the groups detected in the basic clustering mechanism (P)
            and run the t-test for adjacent groups, obtaining a (M × 1) vector
            of convergence test statistics t (where \eqn{M = P - 1} and
            \eqn{m = 1, \dots, M}{m = 1, ..., M});
            \item Merge for adjacent groups starting from the first, under the
            conditions \eqn{t(m) > -1.65} and \eqn{t(m) > t(m+1)}.
            In particular, if both conditions hold, the two clubs determining
            \eqn{t(m)} are merged and the algorithm starts again from step 1,
            otherwise it continues for all following pairs;
            \item For the last element of vector M (the value of the last two clubs)
            the only condition required for merging is \eqn{t(m=M) > -1.65}.
        }

}
}
\examples{
data("countryGDP")

# Cluster Countries using GDP from year 1970 to year 2003
clubs <- findClubs(countryGDP, dataCols=2:35, regions = 1, refCol=35,
                   time_trim = 1/3, cstar = 0, HACmethod = "FQSB")
summary(clubs)

# Merge clusters
mclubs <- mergeClubs(clubs, mergeMethod='PS', mergeDivergent=FALSE)
summary(mclubs)

mclubs <- mergeClubs(clubs, mergeMethod='vLT', mergeDivergent=FALSE)
summary(mclubs)

}
\references{
Phillips, P. C.; Sul, D., 2007. Transition modeling and econometric convergence tests. Econometrica 75 (6), 1771-1855.

Phillips, P. C.; Sul, D., 2009. Economic transition and growth. Journal of Applied Econometrics 24 (7), 1153-1185.

von Lyncker, K.; Thoennessen, R., 2016. Regional club convergence in the EU: evidence from a panel data analysis. Empirical Economics.
}
\seealso{
\code{\link{findClubs}}, finds convergence clubs by means of Phillips and Sul clustering procedure.

\code{\link{mergeDivergent}}, merges divergent units according to the algorithm proposed by von Lyncker and Thoennessen (2016).
}
