#' user_stats
#'
#' @description
#' Calculate user statistics: total posts shared, average time delta.
#'
#' @details
#' With this helper function you get a summary of the users, who
#' share coordinated content.
#' High number of posts shared and low average time delta are indicators for
#' highly coordinated (potentially automated) user behaviour.
#'
#' @param x a result data.table generated by `detect_coordinated_groups`
#' @return a data.table with summary statistics for each user
#'
#' @import data.table
#' @export
#'
#'

user_stats <- function(x) {
    variable <- time_delta <- patterns <- NULL

    x_melted <- data.table::melt(x,
        id.vars = c("object_id", "time_delta"),
        measure.vars = patterns("^content_id", "^id_user"),
        value.name = c("content_id", "id_user")
    )

    x_melted[, variable := NULL]
    x_melted <- unique(x_melted)

    x_dedup <- unique(x_melted, by = c("object_id", "content_id"))

    total_posts_by_user <- x_dedup[, .(total_posts = .N), by = "id_user"]

    time_delta_by_user <- x_melted[, .(mean_time_delta = mean(time_delta)), by = "id_user"]

    x_summary <- merge(total_posts_by_user, time_delta_by_user, by = "id_user")

    data.table::setorder(x_summary, "id_user")
    return(x_summary)
}
