% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshape_tweets.r
\name{reshape_tweets}
\alias{reshape_tweets}
\title{reshape_tweets}
\usage{
reshape_tweets(
  tweets,
  intent = c("retweets", "hashtags", "urls", "urls_domains", "cotweet"),
  drop_retweets = TRUE,
  drop_replies = TRUE,
  drop_hashtags = FALSE
)
}
\arguments{
\item{tweets}{a named list of Twitter data
(output of \link{preprocess_tweets})}

\item{intent}{the desired intent for analysis.}

\item{drop_retweets}{Option passed to \code{intent = "cotweet"}.
When analysing tweets based on text similarity, you can choose to drop
all tweets that are retweets. Default: TRUE}

\item{drop_replies}{Option passed to \code{intent = "cotweet"}.
When analysing tweets based on text similarity, you can choose to drop
all tweets that are replies to other tweets. Default: TRUE}

\item{drop_hashtags}{Option passed to \code{intent = "cotweet"}. You can choose to
remove all hashtags from the tweet texts. Default: FALSE}
}
\value{
a reshaped data.table
}
\description{
Reshape twitter data for coordination detection.
}
\details{
This function takes the pre-processed Twitter data
(output of \link{preprocess_tweets}) and reshapes it
for coordination detection (\link{detect_coordinated_groups}).
You can choose the intent for reshaping the data. Use
\code{"retweets"} to detect coordinated retweeting behaviour;
\code{"hashtags"} for coordinated usage of hashtags;
\code{"urls"} to detect coordinated link sharing behaviour;
\code{"urls_domain"} to detect coordinated link sharing behaviour
at the domain level.
\code{"cotweet"} to detect coordinated cotweeting behaviour
(users posting same text).
The output of this function is a reshaped \code{data.table} that
can be passed to \link{detect_coordinated_groups}.
}
