% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CostSharingGame.R
\name{costSharingGame}
\alias{costSharingGame}
\title{Construct a cost sharing game}
\usage{
costSharingGame(n, Costs)
}
\arguments{
\item{n}{represents the number of players}

\item{Costs}{A vector containing the costs each coalition has to pay}
}
\value{
A list with three elements 
representing the specified cost sharing 
game (n, Costs, Game vector v)
}
\description{
\strong{Create a list containing 
all information about a specified cost sharing game:} \cr
The user may specify the cost function of a cost allocation
problem. A corresponding savings game will be calculated.
The savings game specified by the game vector \code{v} 
will work like an ordinary TU game.
}
\section{Related Functions}{
 
\link{costSharingGameValue}, \link{costSharingGameVector}
}

\examples{
library(CoopGame)
costSharingGame(n=3, Costs=c(2,2,2,3,3,3,4))

\donttest{
#Example with 3 students sharing an appartment:
#-------------------------------
#| costs     |  A  |  B  |  C  |
#- -----------------------------
#|single     | 300 | 270 | 280 |
#|appartment |     |     |     |
#-------------------------------
#
#Appartment for 2 persons => costs: 410
#Appartment for 3 persons => costs: 550

#Savings for all combinations sharing appartments
library(CoopGame)
(vv <- costSharingGame(n=3, Costs=c(300,270,280,410,410,410,550)))
#Output:
#$n
#[1] 3

#$Costs
#[1] 300 270 280 410 410 410 550

#$v
#[1]   0   0   0 160 170 140 300
}

}
\references{
Peleg B. and Sudhoelter P. (2007) \emph{Theory of cooperative games}, 2nd Edition, Springer, pp. 14--16

Maschler M., Solan E. and Zamir S. (2013) \emph{Game Theory}, Cambridge University Press, pp. 667--668
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}

Johannes Anwander \email{anwander.johannes@gmail.com}
}
