% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.CopulaCenR.R
\name{predict.CopulaCenR}
\alias{predict.CopulaCenR}
\title{Predictions from CopulaCenR regression models}
\usage{
\method{predict}{CopulaCenR}(object, newdata, type = "lp", ...)
}
\arguments{
\item{object}{a \code{CopulaCenR} object from \code{ic_spTran_copula},
\code{rc_spCox_copula}, \code{ic_par_copula} and \code{rc_par_copula}}

\item{newdata}{a data frame (see details)}

\item{type}{\code{"lp"} for linear predictors or
\code{"survival"} for marginal and joint survival probabilities}

\item{...}{further arguments}
}
\value{
If \code{type = "lp"}, it returns a data frame with \code{id},
\code{lp1} (linear predictor for margin 1), \code{lp2}.
If \code{type = "survival"}, it returns a data frame with \code{id},
\code{t1} (evaluated times for the margin 1), \code{t2},
\code{S1} (predicted marginal survival probabilities for margin 1),
\code{S2} and
\code{S12} (the predicted joint survival probabilities at \code{t1, t2})
}
\description{
Predictions for new observations based on \code{ic_spTran_copula}, \code{rc_spCox_copula},
\code{ic_par_copula} and \code{rc_par_copula}.
}
\details{
For the \code{newdata}, when \code{type = "survival"}, it must be a data frame with columns
\code{id} (subject id), \code{ind} (1,2 for two margins),
\code{time} (to be evaluted) and \code{covariates};
when \code{type = "lp"}, the newdata needs to have \code{id},
\code{ind} and \code{covariates}, but \code{time} is not needed. \cr

When the argument \code{type = "lp"}, it gives a linear predictor for
each margin (i.e., log hazards ratio in the proportional hazards model,
log proportional odds in the proportional odds model). \cr

When the argument \code{type = "survival"}, the marginal and joint survival values
will be evaluated at the given time points in the \code{newdata}. \cr
}
\examples{
data(AREDS)
# fit a Copula2-Sieve model
copula2_sp <- ic_spTran_copula(data = AREDS, copula = "Copula2",
              l = 0, u = 15, m = 3, r = 3,
              var_list = c("ENROLLAGE","rs2284665","SevScaleBL"))
# Predicted probabilities for newdata
newdata = data.frame(id = rep(1:3, each=2), ind = rep(c(1,2),3),
                     time = c(2,3,5,6,7,8),
                    SevScaleBL = rep(3,6),
                    ENROLLAGE = rep(60,6),
                    rs2284665 = c(0,0,1,1,2,2))
output <- predict(object = copula2_sp, newdata = newdata)
}
