% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density_estimation.R
\name{density_estimation}
\alias{density_estimation}
\title{BIC of estimated  marginal gaussian mixture densities}
\usage{
density_estimation(X = X, nbclustmax = 10, nbclustmin = 1,
  verbose = FALSE, detailed = FALSE, max = TRUE, package = c("mclust",
  "Rmixmod"), nbini = 20, matshape = FALSE, ...)
}
\arguments{
\item{X}{the dataset (matrix)}

\item{nbclustmax}{max number of clusters in the gaussian mixtures}

\item{nbclustmin}{min number of clusters in the gaussian mixtures}

\item{verbose}{verbose or not}

\item{detailed}{boolean to give the details of the mixtures found}

\item{max}{boolean. Use an heuristic to shrink nbclustmax according to the number of individuals in the dataset}

\item{package}{package to use (Rmixmod,mclust)}

\item{nbini}{number of initial points for Rmixmod}

\item{matshape}{boolean to give the detail in matricial shape}

\item{...}{additional parameters}
}
\value{
a list that contains:
\item{BIC_vect}{vector of the BIC (one per variable)}
\item{BIC}{global value of the BIC (\code{=sum(BIC_vect)})}
\item{nbclust}{vector of the numbers of components}
\item{details}{list of matrices that describe each Gaussian Mixture (proportions, means and variances)}
}
\description{
Estimates the density of each covariates with gaussian mixture models and then gives the associated BIC.
}
\examples{
\dontrun{
  rm(list=ls())#clean the workspace
  
require(CorReg)
   #dataset generation
   base=mixture_generator(n=150,p=10,valid=0,ratio=0.4,tp1=1,tp2=1,tp3=1,positive=0.5,
                          R2Y=0.8,R2=0.9,scale=TRUE,max_compl=3,lambda=1)
   X_appr=base$X_appr #learning sample
 density=density_estimation(X = X_appr, detailed = TRUE)#estimation of the marginal densities
density$BIC_vect #vector of the BIC (one per variable)
density$BIC #global value of the BIC (sum of the BICs)
density$nbclust #vector of the numbers of components.
density$details #matrices that describe each Gaussian Mixture (proportions, means and variances)

   }
}

