% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CorShrinkData.R
\name{CorShrinkData}
\alias{CorShrinkData}
\title{Adaptive shrinkage of correlations from a data matrix}
\usage{
CorShrinkData(data, sd_boot = FALSE, thresh_up = 0.99,
  thresh_down = -0.99, image_original = FALSE, image_corshrink = FALSE,
  tol = 1e-06, image.control = list(), optmethod = "mixEM",
  ash.control = list())
}
\arguments{
\item{data}{The samples by features data matrix. May contain NA values.}

\item{sd_boot}{A Boolean variable indicating if the standard errors of the
Fisher z-scores should be computed via Bootstrap methods or
through asymptotic formulation of the problem.}

\item{thresh_up}{Upper threshold for correlations. Defaults to 0.99}

\item{thresh_down}{Lower threshold for correlations. Defaults to -0.99.}

\item{image_original}{if TRUE, plots an image of the non-shrunk original matrix
of correlations.}

\item{image_corshrink}{if TRUE, plots an image of the shrunk matrix
of correlations.}

\item{tol}{The tolerance chosen to check how far apart the CorShrink matrix is from the nearest
positive definite matrix before applying PD completion.}

\item{image.control}{Control parameters for the image when \code{image = TRUE}.}

\item{optmethod}{The optimization method for EM algorithm - can be one of
two techniques \code{mixEM} (mixture EM) and \code{mixVBEM}
(mixture Variational Bayes EM) approaches.The default approach
is \code{mixEM}.}

\item{ash.control}{The control parameters for adaptive shrinkage}
}
\value{
Returns an adaptively shrunk version of the sample correlations matrix.
}
\description{
Performs adaptive shrinkage of the sample correlations starting
from a data matrix (possibly containing NAs).
}
\examples{
data <- get(load(system.file("extdata", "sample_by_feature_data.rda",
                   package = "CorShrink")))
out <- CorShrinkData(data, sd_boot = FALSE, image_original = TRUE,
                      image_corshrink = TRUE, optmethod = "mixEM",
                      image.control = list(x.cex = 0.3, y.cex = 0.3))

}
\references{
False Discovery Rates: A New Deal. Matthew Stephens bioRxiv 038216; doi: http://dx.doi.org/10.1101/038216
}
\keyword{adaptive}
\keyword{correlation}
\keyword{shrinkage,}
