% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deg_rationet.R
\name{get_diff_ratio_net}
\alias{get_diff_ratio_net}
\title{Construct differential expression ratio network}
\usage{
get_diff_ratio_net(
  ref.ratio.dist,
  expr.val,
  log.expr = FALSE,
  scale.degree = FALSE
)
}
\arguments{
\item{ref.ratio.dist}{The expression ratio distribution profile returned by \code{get_ratio_distribution} or \code{get_ratio_distribution2}.}

\item{expr.val}{Numeric vector of gene expression values in the sample.}

\item{log.expr}{Logical variable indicating whether the input expression vector is in logarithmic scale.}

\item{scale.degree}{Logical variable indicating whether the degree values are scaled according to the dropout rate.}
}
\value{
This function will return a list with the following components:
  \item{net}{The binary adjacent matrix of differential expression ratio network.}
  \item{diff}{A numeric vector containing the adjusted degree differences of all genes.}
  \item{degree}{A list containing the raw degree differences and sums of all genes.}
}
\description{
Construct the differential expression ratio network for a single sample.
}
