% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_counternull_set.R
\name{find_counternull_set}
\alias{find_counternull_set}
\title{Finds range of counternull values}
\usage{
find_counternull_set(
  obs_pvalue,
  sample_data,
  extreme,
  rand_matrix,
  permutation_counter_function,
  counternull_value,
  test_stat,
  variable,
  iterations,
  pairs
)
}
\arguments{
\item{obs_pvalue}{P-value from null distribution}

\item{sample_data}{Sample data set. Data should have column indicating
exposure (1) or non exposure (0) for each group (row) that is measured. Each
measured outcome (variable) should be represented by an additional column.}

\item{extreme}{Direction which is defined as more extreme for test statistic
in distribution (0 for left or 1 for right)}

\item{rand_matrix}{Matrix with all possible randomizations of exposure
assignment}

\item{counternull_value}{Number to test out as counternull value}

\item{test_stat}{Observed test statistic. (You can use find_test_stat() to
find difference in means from given dataset)}

\item{variable}{Variable Measurement Format: sample_data$column}

\item{iterations}{Numbers of unique arrangements of exposure assignments
used to generate distribution (At most the number of rows in rand_matrix)}

\item{pairs}{Number of pairs of units there are to measure in dataset
(One pair=control unit + experimental unit)}

\item{permuation_counter_function}{Function used to create permutation vector
for counternull distribution}
}
\value{
Vector of counternull values
}
\description{
Prints full range of counternull values given one counternull value.
}
\keyword{internal}
