% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefnames.R
\name{renewalNames}
\alias{renewalNames}
\title{Get names of parameters of renewal regression models}
\usage{
renewalNames(object, ...)
}
\arguments{
\item{object}{an object.}

\item{...}{further arguments.}
}
\description{
Get names of parameters of renewal regression models
}
\details{
\code{renewalNames} gives the a character vector of names of parameters for
renewal regression models. There are two main use scenarios:
\code{renewalNames(object, target = "dist")} and
\code{renewalNames(object,...)}. In the first scenario \code{target} can be a
count distribution, such as "weibull" or a parameter name, such as shape.  In
this case \code{renewalNames} transforms coefficient names of \code{object}
to those specified by \code{target}. In the second cenario the argument list
is the same that would be used to call \code{renewalCount}. In this case
\code{renewalNames} returns the names that would be used by renewalCount for
the coefficients of the fitted model.
}
