% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/significance.test.R
\name{significance.test}
\alias{significance.test}
\title{Significance test}
\usage{
significance.test(
  formula,
  data,
  params.rfsrc = list(ntree = 1000, mtry = ceiling(px/3), nsplit = max(round(n/50),
    10)),
  nodesize.set = round(0.5^(1:100) * round(0.632 * n))[round(0.5^(1:100) * round(0.632
    * n)) > py],
  nperm = 500,
  test.vars = NULL
)
}
\arguments{
\item{formula}{Object of class \code{formula} or \code{character} describing
the model to fit. Interaction terms are not supported.}

\item{data}{The multivariate data set which has \eqn{n} observations and
\eqn{px+py} variables where \eqn{px} and \eqn{py} are the number of
covariates (\eqn{X}) and response variables (\eqn{Y}), respectively. Should
be a data.frame.}

\item{params.rfsrc}{List of parameters that should be passed to
\code{randomForestSRC}. In the default parameter set, \code{ntree} = 1000,
\code{mtry} = \eqn{px/3}  (rounded up), \code{nsplit} =
\eqn{max(round(n/50), 10)}. See \code{randomForestSRC} for possible
parameters.}

\item{nodesize.set}{The set of \code{nodesize} levels for tuning. Default set
includes the power of two times the sub-sample size (\eqn{.632n}) greater
than the number of response variables (\eqn{py}).}

\item{nperm}{Number of permutations.}

\item{test.vars}{Subset of covariates whose effect on the covariance matrix
estimates will be evaluated. A character vector defining the names of the
covariates. The default is \code{NULL}, which tests for the global effect
of the whole set of covariates.}
}
\value{
An object of class \code{(covregrf, significancetest)} which is a list
with the following components:

  \item{pvalue}{Estimated *p*-value, see below for details.}
  \item{best.nodesize}{Best \code{nodesize} value selected with the proposed
    tuning method using all covariates including the \code{test.vars}.}
  \item{best.nodesize.control}{Best \code{nodesize} value selected with the
    proposed tuning method using only the set of controlling covariates. If
    \code{test.vars} is \code{NULL}, returns \code{NULL}.}
  \item{test.vars}{Covariates whose effect on the covariance matrix estimates
    is evaluated.}
  \item{control.vars}{Controlling set of covariates.}
  \item{predicted.oob}{OOB predicted covariance matrices for training
    observations using all covariates including the \code{test.vars}.}
  \item{predicted.perm}{Predicted covariance matrices for the permutations
    using all covariates including the \code{test.vars}. A list of
    predictions for each permutation.}
  \item{predicted.oob.control}{OOB predicted covariance matrices for training
    observations using only the set of controlling covariates. If
    \code{test.vars} is \code{NULL}, returns \code{NULL}.}
  \item{predicted.perm.control}{Predicted covariance matrices for the
    permutations using only the set of controlling covariates. If
    \code{test.vars} is \code{NULL}, returns \code{NULL}.}
}
\description{
This function runs a permutation test to evaluate the effect of a subset of
  covariates on the covariance matrix estimates. Returns an estimated
  \emph{p}-value.
}
\section{Details}{

We perform a hypothesis test to evaluate the effect of a subset of covariates
  on the covariance matrix estimates, while controlling for the rest of the
  covariates. Define the conditional covariance matrix of \eqn{Y} given all
  \eqn{X} variables as \eqn{\Sigma_{X}}, and the conditional covariance
  matrix of \eqn{Y} given only the set of controlling \eqn{X} variables as
  \eqn{\Sigma_{X}^{c}}. If a subset of covariates has an effect on the
  covariance matrix estimates obtained with the proposed method, then
  \eqn{\Sigma_{X}} should be significantly different from \eqn{\Sigma_{X}^{c}}.
  We conduct a permutation test for the null hypothesis
  \deqn{H_0 : \Sigma_{X} = \Sigma_{X}^{c}} We estimate a
  \eqn{p}-value with the permutation test. If the \eqn{p}-value is less than the
  pre-specified significance level \eqn{\alpha}, we reject the null
  hypothesis.

  Testing the global effect of the covariates on the conditional covariance
  estimates is a particular case of the proposed significance test. Define
  the unconditional covariance matrix estimate of \eqn{Y} as
  \eqn{\Sigma_{root}} which is computed as the sample covariance matrix of
  \eqn{Y}, and the conditional covariance matrix of \eqn{Y} given \eqn{X} as
  \eqn{\Sigma_{X}} which is obtained with \code{covregrf()}. If there is a
  global effect of \eqn{X} on the covariance matrix estimates, the
  \eqn{\Sigma_{X}} should be significantly different from \eqn{\Sigma_{root}}.
  The null hypothesis for this particular case is
  \deqn{H_0 : \Sigma_{X} = \Sigma_{root}}
}

\seealso{
\code{\link{covregrf}}
  \code{\link{predict.covregrf}}
  \code{\link{print.covregrf}}
}
