% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CovDist.R
\name{CovDist}
\alias{CovDist}
\title{Compute pairwise distance for symmetric positive definite matrices.}
\usage{
CovDist(A, method = c("AIRM", "Bhattacharyya", "Cholesky", "Euclidean",
  "Hellinger", "JBLD", "KLDM", "LERM", "Procrustes.SS", "Procrustes.Full",
  "PowerEuclidean", "RootEuclidean"), power = 1)
}
\arguments{
\item{A}{a \code{(p-by-p-by-N)} 3d array of \code{N} SPD matrices.}

\item{method}{the type of distance measures to be used; \code{"AIRM"} for Affine Invariant
Riemannian Metric, \code{"Bhattacharyya"} for Bhattacharyya distance based on normal model,
\code{"Cholesky"} for Cholesky difference in Frobenius norm,
\code{"Euclidean"} for naive Frobenius norm as distance,
\code{"Hellinger"} for Hellinger distance based on normal model,
\code{"JBLD"} for Jensen-Bregman Log Determinant Distance,
\code{"KLDM"} for symmetrized Kullback-Leibler Distance Measure,
\code{"LERM"} for Log Euclidean Riemannian Metric,
\code{"Procrustes.SS"} for Procrustes Size and Shape measure,
\code{"Procrustes.Full"} for Procrustes analysis with scale,
\code{"PowerEuclidean"} for weighted eigenvalues by some exponent, and
\code{"RootEuclidean"} for matrix square root.}

\item{power}{a non-zero number for PowerEuclidean distance.}
}
\value{
an \code{(N-by-N)} symmetric matrix of pairwise distances.
}
\description{
For a given 3-dimensional array where symmetric positive definite (SPD) matrices are stacked slice
by slice, it computes pairwise distance using various popular measures. Some of measures
are \emph{metric} as they suffice 3 conditions in mathematical context; nonnegative definiteness,
symmetry, and triangle inequalities. Other non-metric measures represent \emph{dissimilarities} between
two SPD objects.
}
\examples{
## generate 100 SPD matrices of size (5-by-5)
samples = samplecovs(100,5)

## get pairwise distance for "AIRM"
distAIRM = CovDist(samples, method="AIRM")

## dimension reduction using MDS
ss = cmdscale(distAIRM)
plot(ss[,1],ss[,2],main="2d projection")


}
\references{
Arsigny, V., Fillard, P., Pennec, X., and Ayache, N. (2006) \emph{Log-Euclidean
Metrics for Fast and Simple Calculus on Diffusion Tensors.} Magnetic Resonance in Medicine, 56:411-421.

Dryden, I.L., Koloydenko, A., and Zhou, D. (2009) \emph{Non-Euclidean
statistics for covariance matrices, with applications to diffusion tensor imaging.} The
Annals of Applied Statistics, Vol.3(3):1102-1123.
}
