% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PreEst.R
\name{PreEst}
\alias{PreEst}
\title{Estimating Precision Matrix}
\usage{
PreEst(X, method = c("Banerjee06", "Banerjee14", "Lee17", "Yuan07"),
  opt = list(Banerjee06.confidence = 0.95, Banerjee14.upperK =
  floor(ncol(X)/2), Banerjee14.delta = 10, Banerjee14.logpi = function(k) {    
  -k^4 }, Banerjee14.loss = c("Stein", "Squared"), Lee17.upperK =
  floor(ncol(X)/2), Lee17.logpi = function(k) {     -k^4 }, Yuan07.lambda = 1))
}
\arguments{
\item{X}{an \code{(n-by-p)} matrix where each row is an observation from the first dataset.}

\item{method}{a name of estimation method.}

\item{opt}{a list containing following parameters, \describe{
\item{Banerjee06.confidence}{level of confidence in \eqn{(0,1)}.}
\item{Banerjee14.upperK}{upper bound for bandwidth.}
\item{Banerjee14.delta}{a number larger than 2.}
\item{Banerjee14.logpi}{log of prior distribution for bandwidth \code{k}.}
\item{Banerjee14.loss}{loss type; either \code{"Stein"} or \code{"Squared"} type.}
\item{Lee17.upperK}{upper bound for bandwidth.}
\item{Lee17.logpi}{log of prior distribution for bandwidth \code{k}.}
\item{Yuan07.lambda}{a regularization parameter.}
}}
}
\value{
a \code{(p-by-p)} estimated precision matrix.
}
\description{
This code compiles several estimation methods for \emph{precision} matrix, which is
an inverse of covariance matrix, including penalized likelihood method with L1 penalty(\code{Yuan07}, \code{Banerjee06})
or Bayesian approaches incorporating banded structure assumptions(\code{Banerjee14},\code{Lee17}).
}
\examples{
## generate data from multivariate normal with Identity precision.
data = mvtnorm::rmvnorm(100, sigma=diag(10))

## run estimation
out1 = PreEst(data, method="Banerjee06")
out2 = PreEst(data, method="Banerjee14")
out3 = PreEst(data, method="Lee17")
out4 = PreEst(data, method="Yuan07")

## Visualize
par(mfrow=c(2,2))
image(pracma::flipud(out1), main="Banerjee06")
image(pracma::flipud(out2), main="Banerjee14")
image(pracma::flipud(out3), main="Lee17")
image(pracma::flipud(out4), main="Yuan07")

}
\references{
[Banerjee06] Banerjee et al (2006) \emph{Convex optimization techniques for fitting sparse Gaussian graphical models.} ICML'06:89-96.

[Banerjee14] Banerjee, S. and Ghosal, S. (2014) \emph{Posterior convergence rates for estimating large precision matrices using graphical models.} Electronic Journal of Statistics, Vol.8:2111-2137.

[Lee17] Lee, K. and Lee, J. (2017) \emph{Estimating Large Precision Matrices via Modified Cholesky Decomposition.} arXiv:1707.01143.

[Yuan07] Yuan, M. and Lin, Y. (2007) \emph{Model selection and estimation in the Gaussian graphical model.} Biometrika, Vol.94(1):19-35.
}
