% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package-CovTools.R
\docType{package}
\name{package-CovTools}
\alias{package-CovTools}
\alias{package-CovTools-package}
\title{A Collection of Geometric and Statistical Tools for Covariance Analysis}
\description{
Covariance is of universal prevalence across various disciplines within statistics.
\pkg{CovTools} package aims at providing a rich collection of geometric and statistical tools
for a variety of inferences on covariance structures. See the sections below for a comprehensive
list of functions provided from the package.
}
\section{Geometric Methods}{

From inference on manifolds perspective, we have following functions,
\tabular{cc}{
\emph{name of a function} \tab \emph{description} \cr
\code{\link{CovDist}} \tab compute pairwise distance of covariance matrices \cr
\code{\link{CovMean}}\tab compute mean covariance matrix
}
}

\section{Statistical methods}{

We provide statistical methods for
(1) \strong{Covariance Matrix Estimation},
\tabular{ll}{
\emph{name of a function}\tab \emph{description} \cr
\code{\link{CovEst.adaptive}} \tab Adaptive Thresholding \cr
\code{\link{CovEst.hard}} \tab Hard Thresholding \cr
\code{\link{CovEst.hardPD}} \tab Hard Thresholding under Positive-Definiteness Constraint \cr
\code{\link{CovEst.nearPD}} \tab Nearest Positive-Definite Matrix Projection \cr
\code{\link{CovEst.soft}} \tab Soft Thresholding
}
(2) \strong{Precision Matrix Estimation}
\tabular{ll}{
\emph{name of a function}\tab \emph{description} \cr
\code{\link{PreEst.banded1}} \tab Bayesian Estimation of a Banded Precision Matrix (Banerjee 2014) \cr
\code{\link{PreEst.banded2}} \tab Bayesian Estimation of a Banded Precision Matrix (Lee 2017) \cr
\code{\link{PreEst.banded3}} \tab Banded Precision Matrix Estimation via Bandwidth Test \cr
\code{\link{PreEst.glasso}} \tab Graphical Lasso
}
(3) \strong{Frequentist Hypothesis Tests}
\tabular{ll}{
\emph{name of a function} \tab \emph{description} \cr
\code{\link{CovTest1}} \tab 1-sample Covariance Tests\cr
\code{\link{CovTest2}} \tab 2-sample Covariance Tests
}
(4) \strong{Bayesian Hypothesis Tests}
\tabular{ll}{
\emph{name of a function} \tab \emph{description} \cr
\code{\link{BayesTest1}} \tab 1-sample Bayesian Covariance Tests
}
(5) \strong{Others}
\tabular{ll}{
\emph{name of a function} \tab \emph{description} \cr
\code{\link{DiagTest1}} \tab Diagonality Test of Covariance
}
}

