% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxmos_plot_functions.R
\name{plot_events}
\alias{plot_events}
\title{plot_events}
\usage{
plot_events(
  Y,
  max.breaks = 20,
  roundTo = 0.1,
  categories = c("Censored", "Event"),
  y.text = "Number of observations",
  decimals = 5,
  txt.x.angle = 0,
  verbose = FALSE
)
}
\arguments{
\item{Y}{Numeric matrix or data.frame. Response variables. Object must have two columns named as
"time" and "event". For event column, accepted values are: 0/1 or FALSE/TRUE for censored and
event observations.}

\item{max.breaks}{Numeric. Maximum number of breaks in X axis (default: 20).}

\item{roundTo}{Numeric. Value to round time. If roundTo = 0.1, the results will be rounded to the
tenths (default: 0.1).}

\item{categories}{Character vector. Vector of length two to name both categories for censored and
non-censored observations (default: c("Censored","Death")).}

\item{y.text}{Character. Y axis title (default: "Number of observations").}

\item{decimals}{Numeric. Number of decimals to use in round times. Must be a value greater or
equal zero (default = 5).}

\item{txt.x.angle}{Numeric. Angle of the text for the x-axis labels (default: 0).}

\item{verbose}{Logical. If verbose = TRUE, extra messages could be displayed (default: FALSE).}
}
\value{
A list of 8 elements.
\code{plot}: Ggplot object for ploting distribution of events per group.
\code{plot_percent}: Ggplot object for ploting \% of distribution of events per total number of observations.
\code{plot_percent_class}: Ggplot object for ploting \% of distribution of events relative to group.
\code{plot_percent_time}: Ggplot object for ploting \% of distribution of events relative to break-time.
\code{df}: Data.frame used for the plotting corresponding plot.
\code{df_percent}: Data.frame used for the plotting corresponding plot.
\code{dd_percent_cat}: Data.frame used for the plotting corresponding plot.
\code{dd_percent_time}: Data.frame used for the plotting corresponding plot.
}
\description{
Generates multiple bar plots to visualize the distribution of events over time, categorizing
observations as either censored or non-censored.
}
\details{
The \code{plot_events} function is meticulously crafted to provide a visualization of event
occurrences over a specified time frame. The primary objective of this function is to elucidate
the distribution of events, distinguishing between censored and non-censored observations. The
input response matrix, "Y", is expected to encompass two pivotal columns: "time" and "event".
The "time" column delineates the temporal occurrence of each observation, while the "event"
column demarcates whether an observation is censored or an event, with accepted binary
representations being 0/1 or FALSE/TRUE.

The function employs a systematic approach to categorize the time variable into distinct intervals
or "breaks". The number of these intervals is determined by the "max.breaks" parameter, and their
size is influenced by the "roundTo" parameter. Each interval represents a range of time values,
and the resulting plot showcases the number of censored and non-censored observations within each
interval. The bars in the plot are color-coded based on the event type, offering a clear visual
distinction between the two categories.
}
\examples{
data("X_proteomic")
data("Y_proteomic")
Y_train <- Y_proteomic
plot_events(Y_train, categories = c("Censored","Event"))
}
\author{
Pedro Salguero Garcia. Maintainer: pedsalga@upv.edu.es
}
