% Generated by roxygen2 (4.0.2): do not edit by hand
\name{CrossClustering}
\alias{CrossClustering}
\title{A partial clustering algorithm with automatic estimation of the number of clusters and identification of outliers}
\usage{
CrossClustering(d, k.w.min = 2, k.w.max, k.c.max, out = TRUE)
}
\arguments{
\item{d}{a dissimilarity structure as produced by the function \code{dist}}

\item{k.w.min}{minimum number of clusters for the Ward's minimum variance method. By default is set equal 2}

\item{k.w.max}{maximum number of clusters for the Ward's minimum variance method (see details)}

\item{k.c.max}{maximum number of clusters for the Complete-linkage method. It can not be equal or greater than the number of elements to cluster (see details)}

\item{out}{logical. If \code{TRUE} (default) outliers must be searched (see details)}
}
\value{
A list of objects describing characteristics of the partitioning as follows:
\item{Optimal.cluster}{number of clusters}
\item{Cluster.list}{a list of clusters; each element of this lists contains the indices of the elemenents belonging to the cluster}
\item{Silhouette}{the average silhouette witdh over all the clusters}
\item{n.total}{total number of input elements}
\item{n.clustered}{number of input elements that have actually been clustered}
}
\description{
This function performs the CrossClustering algorithm. This method combines the Ward's minimum variance and Complete Linkage algorithms, providing automatic estimation of a suitable number of clusters and identification of outlier elements.
}
\details{
See cited document for more details.
}
\examples{
### Generate simulated data
toy <- matrix(NA, nrow=10, ncol=7)
colnames(toy) <- paste("Sample", 1:ncol(toy), sep="")
rownames(toy) <- paste("Gene", 1:nrow(toy), sep="")
set.seed(123)
toy[,1:2] <- rnorm(n=nrow(toy)*2, mean=10, sd=0.1)
toy[,3:4] <- rnorm(n=nrow(toy)*2, mean=20, sd=0.1)
toy[,5:6] <- rnorm(n=nrow(toy)*2, mean=5, sd=0.1)
toy[,7] <- runif(n=nrow(toy), min=0, max=1)

### toy is transposed as we want to cluster samples (columns of the original matrix)
d <- dist(t(toy), method="euclidean")

### Run CrossClustering
toyres <- CrossClustering(d, k.w.min=2, k.w.max=5, k.c.max=6, out=TRUE)
}
\author{
Paola Tellaroli, \email{paola.tellaroli@unipd.it}; Michele Donato, \email{michele.donato@wayne.edu}
}
\references{
Tellaroli, P., Bazzi, M., Donato, M., Brazzale, A. R., Draghici, S. (2016) Cross Clustering: a partial clustering algorithm with automatic estimation of the number of clusters. PLOS One (In Press)
}

