% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_relevant.R
\name{MDFS}
\alias{MDFS}
\title{Build MultiDimensional Feature Selector from IGs}
\usage{
MDFS(IGs, dimensions, divisions, response_divisions = 1, IG_bits = TRUE,
  IG_doubled = FALSE, ignore_lowest = length(IGs)\%/\%10,
  variable_number = length(IGs), calc_variable_number = TRUE,
  mode_1D = "exp", min_variable_number = variable_number\%/\%2,
  max_ignore_lowest = variable_number\%/\%3, max_iterations = 20,
  acceptable_error = 0.05)
}
\arguments{
\item{IGs}{max conditional information gains}

\item{dimensions}{number of dimensions}

\item{divisions}{number of divisions}

\item{response_divisions}{number of response divisions (i.e. categories-1)}

\item{IG_bits}{input is in binary log (as opposed to natural log)}

\item{IG_doubled}{input is doubled (to follow the chi-squared distribution)}

\item{ignore_lowest}{number of variables with the lowest IG to ignore (ignored if computed)}

\item{variable_number}{number of irrelevant variables (ignored if computed)}

\item{calc_variable_number}{whether to compute the number of neglected and irrelevant variables}

\item{mode_1D}{"exp" - exponential distribution, "lin" - linear function of chi-squared, "raw" - raw chi-squared}

\item{min_variable_number}{minimum number of irrelevant variables}

\item{max_ignore_lowest}{maximum number of ignored variables}

\item{max_iterations}{maximum number of iterations in variable number calculation}

\item{acceptable_error}{acceptable error level for distribution parameter}
}
\value{
MDFS (list-based S3 class object) with the following named elements:
  "IGs" is a vector of information gains (input copy)
  "order" is a vector of ordinal numbers (order of variables by decreasing score)
  "chi.squared" is a vector of chi-squared p-values
  "p.values" is a vector of eventual p-values
  "scores" is a list of two vectors FDR and FWER with FDR and FWER scores respectively
  "lo.sq.dev." is a vector of square deviations used to calculate the number of ignored variables
  "hi.sq.dev." is a vector of square deviations used to calculate the number of irrelevant variables
  "ign.lowest" is a number of ignored variables
  "var.number" is a number of irrelevant variables
  "dist.param." is an exponential distribution parameter or linear coefficient
  "err.param." is a square error of the parameter
}
\description{
Build MultiDimensional Feature Selector from IGs
}

