% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/users.R
\name{users}
\alias{users}
\alias{users.list,UserSession-method}
\alias{users.list}
\alias{users.show,UserSession-method}
\alias{users.show}
\title{User Endpoints}
\usage{
\S4method{users.list}{UserSession}(
  UserSession,
  output = "default",
  timeout = UserSession@short_timeout
)

\S4method{users.show}{UserSession}(
  UserSession,
  user_id,
  output = "default",
  timeout = UserSession@short_timeout
)
}
\arguments{
\item{UserSession}{Cytobank UserSession object}

\item{output}{character representing the output format \strong{[optional]}\cr
\emph{- users.list, users.show : \code{("default", "raw")}}}

\item{timeout}{integer representing the request timeout time in seconds \strong{[optional]}}

\item{user_id}{integer representing a user ID}
}
\description{
Interact with user endpoints. One should never analyze alone...
}
\details{
\code{users.list} List all users from an experiment. Outputs a dataframe [default] or raw list with all fields present.\cr
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}

\code{users.show} Show user details from an experiment.
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}
}
\examples{
\dontrun{# Authenticate via username/password
cyto_session <- authenticate(site="premium", username="cyril_cytometry", password="cytobank_rocks!")
# Authenticate via auth_token
cyto_session <- authenticate(site="premium", auth_token="my_secret_auth_token")
}
\dontrun{# Dataframe of all users with all fields present
users.list(cyto_session)

# Raw list of all useres with all fields present
users.list(cyto_session, output="raw")
}
\dontrun{users.show(cyto_session, user_id=2)
}
}
