% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.Accuracy.R
\name{Accuracy}
\alias{Accuracy}
\title{Computes the Accuracy measure.}
\description{
Computes the ratio of number of correct predictions to the total
number of input samples.
}
\details{
\deqn{Accuracy = (Number Correct Predictions) / (Total Number of
Predictions)}
}
\seealso{
\code{\link{MeasureFunction}}, \code{\link{ClassificationOutput}},
\code{\link{ConfMatrix}}.
}
\keyword{classif}
\keyword{math}
\section{Super class}{
\code{\link[D2MCS:MeasureFunction]{D2MCS::MeasureFunction}} -> \code{Accuracy}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Accuracy-new}{\code{Accuracy$new()}}
\item \href{#method-Accuracy-compute}{\code{Accuracy$compute()}}
\item \href{#method-Accuracy-clone}{\code{Accuracy$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Accuracy-new"></a>}}
\if{latex}{\out{\hypertarget{method-Accuracy-new}{}}}
\subsection{Method \code{new()}}{
Method for initializing the object arguments during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Accuracy$new(performance.output = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{performance.output}}{An optional \code{\link{ConfMatrix}} used as
basis to compute the performance.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Accuracy-compute"></a>}}
\if{latex}{\out{\hypertarget{method-Accuracy-compute}{}}}
\subsection{Method \code{compute()}}{
The function computes the \strong{Accuracy} achieved by the
M.L. model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Accuracy$compute(performance.output = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{performance.output}}{An optional \code{\link{ConfMatrix}} parameter
to define the type of object used as basis to compute the
\strong{Accuracy} measure.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This function is automatically invoke by the
\code{\link{ClassificationOutput}} object.
}

\subsection{Returns}{
A \link{numeric} vector of size 1 or \link{NULL} if an error
occurred.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Accuracy-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Accuracy-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Accuracy$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
