% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/clustering.strategies.DependencyBasedStrategyConfiguration.R
\name{DependencyBasedStrategyConfiguration}
\alias{DependencyBasedStrategyConfiguration}
\title{Custom Strategy Configuration handler for the DependencyBasedStrategy
strategy.}
\description{
Define the default configuration parameters for the
\link{DependencyBasedStrategy} strategy.
}
\seealso{
\code{\link{StrategyConfiguration}},
\code{\link{DependencyBasedStrategy}}
}
\keyword{cluster}
\keyword{manip}
\section{Super class}{
\code{\link[D2MCS:StrategyConfiguration]{D2MCS::StrategyConfiguration}} -> \code{DependencyBasedStrategyConfiguration}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DependencyBasedStrategyConfiguration-new}{\code{DependencyBasedStrategyConfiguration$new()}}
\item \href{#method-DependencyBasedStrategyConfiguration-minNumClusters}{\code{DependencyBasedStrategyConfiguration$minNumClusters()}}
\item \href{#method-DependencyBasedStrategyConfiguration-maxNumClusters}{\code{DependencyBasedStrategyConfiguration$maxNumClusters()}}
\item \href{#method-DependencyBasedStrategyConfiguration-getBinaryCutoff}{\code{DependencyBasedStrategyConfiguration$getBinaryCutoff()}}
\item \href{#method-DependencyBasedStrategyConfiguration-getRealCutoff}{\code{DependencyBasedStrategyConfiguration$getRealCutoff()}}
\item \href{#method-DependencyBasedStrategyConfiguration-setBinaryCutoff}{\code{DependencyBasedStrategyConfiguration$setBinaryCutoff()}}
\item \href{#method-DependencyBasedStrategyConfiguration-setRealCutoff}{\code{DependencyBasedStrategyConfiguration$setRealCutoff()}}
\item \href{#method-DependencyBasedStrategyConfiguration-tiebreak}{\code{DependencyBasedStrategyConfiguration$tiebreak()}}
\item \href{#method-DependencyBasedStrategyConfiguration-qualityOfCluster}{\code{DependencyBasedStrategyConfiguration$qualityOfCluster()}}
\item \href{#method-DependencyBasedStrategyConfiguration-isImprovingClustering}{\code{DependencyBasedStrategyConfiguration$isImprovingClustering()}}
\item \href{#method-DependencyBasedStrategyConfiguration-clone}{\code{DependencyBasedStrategyConfiguration$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DependencyBasedStrategyConfiguration-new"></a>}}
\if{latex}{\out{\hypertarget{method-DependencyBasedStrategyConfiguration-new}{}}}
\subsection{Method \code{new()}}{
Method for initializing the object arguments during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DependencyBasedStrategyConfiguration$new(
  binaryCutoff = 0.6,
  realCutoff = 0.6,
  tiebreakMethod = "lfdc",
  metric = "dep.tar"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{binaryCutoff}}{The \link{numeric} value of binary cutoff.}

\item{\code{realCutoff}}{The \link{numeric} value of real cutoff.}

\item{\code{tiebreakMethod}}{The \link{character} value of tie-break method. The
two tiebreak methods available are "lfdc" (less dependence cluster with
the features) and "ltdc" (less dependence cluster with the target). These
methods are used to add the features in the candidate feature clusters.}

\item{\code{metric}}{The \link{character} value of the metric to apply the mean
to obtain the quality of a cluster. The two metrics available are
"dep.tar" (Dependence of cluster features on the target) and "dep.fea"
(Dependence between cluster features).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DependencyBasedStrategyConfiguration-minNumClusters"></a>}}
\if{latex}{\out{\hypertarget{method-DependencyBasedStrategyConfiguration-minNumClusters}{}}}
\subsection{Method \code{minNumClusters()}}{
Function used to return the minimum number of clusters
distributions used. By default the minimum is set in 2.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DependencyBasedStrategyConfiguration$minNumClusters(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Further arguments passed down to \code{minNumClusters}
function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{numeric} vector of length 1.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DependencyBasedStrategyConfiguration-maxNumClusters"></a>}}
\if{latex}{\out{\hypertarget{method-DependencyBasedStrategyConfiguration-maxNumClusters}{}}}
\subsection{Method \code{maxNumClusters()}}{
The function is responsible of returning the maximum number
of cluster distributions used. By default the maximum number is set in 50.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DependencyBasedStrategyConfiguration$maxNumClusters(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Further arguments passed down to \code{maxNumClusters}
function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{numeric} vector of length 1.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DependencyBasedStrategyConfiguration-getBinaryCutoff"></a>}}
\if{latex}{\out{\hypertarget{method-DependencyBasedStrategyConfiguration-getBinaryCutoff}{}}}
\subsection{Method \code{getBinaryCutoff()}}{
Gets the cutoff to consider the dependency between binary
features.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DependencyBasedStrategyConfiguration$getBinaryCutoff()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The \link{numeric} value of binary cutoff.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DependencyBasedStrategyConfiguration-getRealCutoff"></a>}}
\if{latex}{\out{\hypertarget{method-DependencyBasedStrategyConfiguration-getRealCutoff}{}}}
\subsection{Method \code{getRealCutoff()}}{
Gets the cutoff to consider the dependency between real
features.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DependencyBasedStrategyConfiguration$getRealCutoff()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The \link{numeric} value of real cutoff.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DependencyBasedStrategyConfiguration-setBinaryCutoff"></a>}}
\if{latex}{\out{\hypertarget{method-DependencyBasedStrategyConfiguration-setBinaryCutoff}{}}}
\subsection{Method \code{setBinaryCutoff()}}{
Sets the cutoff to consider the dependency between binary
features.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DependencyBasedStrategyConfiguration$setBinaryCutoff(cutoff)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cutoff}}{The new \link{numeric} value of binary cutoff.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DependencyBasedStrategyConfiguration-setRealCutoff"></a>}}
\if{latex}{\out{\hypertarget{method-DependencyBasedStrategyConfiguration-setRealCutoff}{}}}
\subsection{Method \code{setRealCutoff()}}{
Sets the cutoff to consider the dependency between real
features.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DependencyBasedStrategyConfiguration$setRealCutoff(cutoff)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cutoff}}{The new \link{numeric} value of real cutoff.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DependencyBasedStrategyConfiguration-tiebreak"></a>}}
\if{latex}{\out{\hypertarget{method-DependencyBasedStrategyConfiguration-tiebreak}{}}}
\subsection{Method \code{tiebreak()}}{
The function solves the ties between two (or more) features.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DependencyBasedStrategyConfiguration$tiebreak(
  feature,
  clus.candidates,
  fea.dep.dist.clus,
  corpus,
  heuristic,
  class,
  class.name
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature}}{A \link{character} containing the name of the feature}

\item{\code{clus.candidates}}{A single or \link{numeric} vector value to
identify the candidate groups to insert the feature.}

\item{\code{fea.dep.dist.clus}}{A \link{list} containing the groups chosen for
the features.}

\item{\code{corpus}}{A \link{data.frame} containing the features of the initial
data.}

\item{\code{heuristic}}{The heuristic used to compute the relevance of each
feature. Must inherit from \link{GenericHeuristic} abstract class.}

\item{\code{class}}{A \link{character} vector containing all the values of the
target class.}

\item{\code{class.name}}{A \link{character} value representing the name of the
target class.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DependencyBasedStrategyConfiguration-qualityOfCluster"></a>}}
\if{latex}{\out{\hypertarget{method-DependencyBasedStrategyConfiguration-qualityOfCluster}{}}}
\subsection{Method \code{qualityOfCluster()}}{
The function determines the quality of a cluster.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DependencyBasedStrategyConfiguration$qualityOfCluster(clusters, metrics)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{clusters}}{A \link{list} with the feature distribution of each
cluster.}

\item{\code{metrics}}{A numeric \link{list} with the metrics associated to the
cluster (dependency between all features and dependency between the
features and the class).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{numeric} vector of length 1.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DependencyBasedStrategyConfiguration-isImprovingClustering"></a>}}
\if{latex}{\out{\hypertarget{method-DependencyBasedStrategyConfiguration-isImprovingClustering}{}}}
\subsection{Method \code{isImprovingClustering()}}{
The function indicates if clustering is getting better as
the number of them increases.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DependencyBasedStrategyConfiguration$isImprovingClustering(clusters.deltha)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{clusters.deltha}}{A \link{numeric} vector value with the quality
values of the built clusters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{numeric} vector of length 1.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DependencyBasedStrategyConfiguration-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DependencyBasedStrategyConfiguration-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DependencyBasedStrategyConfiguration$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
