% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.TN.R
\name{TN}
\alias{TN}
\title{Computes the True Negative value.}
\description{
This is the number of individuals with a negative condition for
which the test result is negative. The value entered here must be non-negative.
}
\seealso{
\code{\link{MeasureFunction}}, \code{\link{ClassificationOutput}},
\code{\link{ConfMatrix}}
}
\keyword{classif}
\keyword{math}
\section{Super class}{
\code{\link[D2MCS:MeasureFunction]{D2MCS::MeasureFunction}} -> \code{TN}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TN-new}{\code{TN$new()}}
\item \href{#method-TN-compute}{\code{TN$compute()}}
\item \href{#method-TN-clone}{\code{TN$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TN-new"></a>}}
\if{latex}{\out{\hypertarget{method-TN-new}{}}}
\subsection{Method \code{new()}}{
Method for initializing the object arguments during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TN$new(performance.output = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{performance.output}}{An optional \code{\link{ConfMatrix}} parameter
to define the type of object used to compute the \strong{TN} measure.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TN-compute"></a>}}
\if{latex}{\out{\hypertarget{method-TN-compute}{}}}
\subsection{Method \code{compute()}}{
The function computes the \strong{TN} achieved by the M.L. model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TN$compute(performance.output = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{performance.output}}{An optional \code{\link{ConfMatrix}} parameter
to define the type of object used as basis to compute the \strong{TN}
measure.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This function is automatically invoke by the
\code{\link{ClassificationOutput}} object.
}

\subsection{Returns}{
A \link{numeric} vector of size 1 or \link{NULL} if
an error occurred.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TN-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TN-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TN$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
