% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yhat.R
\name{yhat.WrappedModel}
\alias{yhat.WrappedModel}
\alias{yhat.H2ORegressionModel}
\alias{yhat.H2OBinomialModel}
\alias{yhat.H2OMultinomialModel}
\alias{yhat.scikitlearn_model}
\alias{yhat.keras}
\alias{yhat.LearnerRegr}
\alias{yhat.LearnerClassif}
\title{Wrapper over the predict function}
\usage{
\method{yhat}{WrappedModel}(X.model, newdata, ...)

\method{yhat}{H2ORegressionModel}(X.model, newdata, ...)

\method{yhat}{H2OBinomialModel}(X.model, newdata, ...)

\method{yhat}{H2OMultinomialModel}(X.model, newdata, ...)

\method{yhat}{scikitlearn_model}(X.model, newdata, ...)

\method{yhat}{keras}(X.model, newdata, ...)

\method{yhat}{LearnerRegr}(X.model, newdata, ...)

\method{yhat}{LearnerClassif}(X.model, newdata, ...)
}
\arguments{
\item{X.model}{object - a model to be explained}

\item{newdata}{data.frame or matrix - observations for prediction}

\item{...}{other parameters that will be passed to the predict function}
}
\value{
An numeric vector of predictions
}
\description{
These functios are default predict functions.
Each function returns a single numeric score for each new observation.
Those functions are very important since informations from many models have to be extracted with various techniques.
}
\details{
Currently supported packages are:
\itemize{
\item \code{mlr} see more in \code{\link{explain_mlr}}
\item \code{h2o} see more in \code{\link{explain_h2o}}
\item \code{scikit-learn} see more in \code{\link{explain_scikitlearn}}
\item \code{keras} see more in \code{\link{explain_keras}}
\item \code{mlr3} see more in \code{\link{explain_mlr3}}
}
}
